/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.server;

import org.apache.cassandra.thrift.CassandraDaemon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CassandraServerController {
    private static Log log = LogFactory.getLog(CassandraServerController.class);
    private final CassandraDaemon cassandraSever = new CassandraDaemon();
    private Thread thread;

    public void start() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Activating the Cassandra Server");
                }
                CassandraServerController.this.cassandraSever.activate();
                log.info((Object)"Cassandra Server Controller Thread was destroyed successfully");
            }
        }, "CassandraServerController");
        this.thread.start();
    }

    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivating the Cassandra Server");
        }
        this.cassandraSever.deactivate();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

