/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.cassandra.server.CassandraServerException;
import org.wso2.carbon.identity.authentication.AuthenticationService;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class CassandraServerComponentManager {
    private static Log log = LogFactory.getLog(CassandraServerComponentManager.class);
    private static CassandraServerComponentManager ourInstance = new CassandraServerComponentManager();
    private RealmService realmService;
    private AuthenticationService authenticationService;
    private ServerConfigurationService serverConfigurationService;
    private boolean initialized = false;

    public static CassandraServerComponentManager getInstance() {
        return ourInstance;
    }

    private CassandraServerComponentManager() {
    }

    public void init(RealmService realmService, AuthenticationService authenticationService, ServerConfigurationService serverConfigurationService) {
        this.realmService = realmService;
        this.authenticationService = authenticationService;
        this.serverConfigurationService = serverConfigurationService;
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new CassandraServerException("Cassandra server Component has not been initialized", log);
        }
    }

    public AuthenticationService getAuthenticationService() {
        this.assertInitialized();
        return this.authenticationService;
    }

    public UserRealm getRealmForTenant(String domainName) {
        this.assertInitialized();
        try {
            int tenantID = this.realmService.getTenantManager().getTenantId(domainName);
            return this.realmService.getTenantUserRealm(tenantID);
        }
        catch (UserStoreException e) {
            throw new CassandraServerException("Error accessing the UserRealm for super tenant : " + (Object)((Object)e), log);
        }
    }

    public void destroy() {
        this.realmService = null;
        this.authenticationService = null;
        this.initialized = false;
    }
}

