/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.BooleanSerializer;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.DateSerializer;
import me.prettyprint.cassandra.serializers.DoubleSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.hector.api.ResultStatus;
import me.prettyprint.hector.api.Serializer;

public abstract class AbstractResultWrapper<K, N>
implements ColumnFamilyResult<K, N> {
    protected Serializer<K> keySerializer;
    protected Serializer<N> columnNameSerializer;
    protected ResultStatus resultStatus;

    public AbstractResultWrapper(Serializer<K> keySerializer, Serializer<N> columnNameSerializer, ResultStatus resultStatus) {
        this.keySerializer = keySerializer;
        this.columnNameSerializer = columnNameSerializer;
        this.resultStatus = resultStatus;
    }

    public abstract ByteBuffer getColumnValue(N var1);

    @Override
    public UUID getUUID(N columnName) {
        return UUIDSerializer.get().fromByteBuffer(this.getColumnValue(columnName));
    }

    @Override
    public String getString(N columnName) {
        return StringSerializer.get().fromByteBuffer(this.getColumnValue(columnName));
    }

    @Override
    public Long getLong(N columnName) {
        return LongSerializer.get().fromByteBuffer(this.getColumnValue(columnName));
    }

    @Override
    public Integer getInteger(N columnName) {
        return IntegerSerializer.get().fromByteBuffer(this.getColumnValue(columnName));
    }

    @Override
    public Double getDouble(N columnName) {
        return DoubleSerializer.get().fromByteBuffer(this.getColumnValue(columnName));
    }

    @Override
    public Boolean getBoolean(N columnName) {
        return BooleanSerializer.get().fromByteBuffer(this.getColumnValue(columnName));
    }

    @Override
    public byte[] getByteArray(N columnName) {
        return BytesArraySerializer.get().fromByteBuffer(this.getColumnValue(columnName));
    }

    @Override
    public Date getDate(N columnName) {
        return DateSerializer.get().fromByteBuffer(this.getColumnValue(columnName));
    }

    @Override
    public long getExecutionTimeMicro() {
        return this.resultStatus.getExecutionTimeMicro();
    }

    @Override
    public long getExecutionTimeNano() {
        return this.resultStatus.getExecutionTimeNano();
    }

    @Override
    public CassandraHost getHostUsed() {
        return this.resultStatus.getHostUsed();
    }
}

