/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model.thrift;

import java.util.List;
import me.prettyprint.cassandra.model.AbstractSliceQuery;
import me.prettyprint.cassandra.model.CounterSliceImpl;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.model.QueryResultImpl;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.CounterSlice;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.SliceCounterQuery;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.CounterColumn;

public final class ThriftSliceCounterQuery<K, N>
extends AbstractSliceQuery<K, N, Long, CounterSlice<N>>
implements SliceCounterQuery<K, N> {
    private K key;

    public ThriftSliceCounterQuery(Keyspace k, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        super(k, keySerializer, nameSerializer, LongSerializer.get());
    }

    @Override
    public SliceCounterQuery<K, N> setKey(K key) {
        this.key = key;
        return this;
    }

    @Override
    public QueryResult<CounterSlice<N>> execute() {
        return new QueryResultImpl<CounterSlice<N>>(this.keyspace.doExecute(new KeyspaceOperationCallback<CounterSlice<N>>(){

            @Override
            public CounterSlice<N> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftSliceCounterQuery.this.columnFamilyName);
                List<CounterColumn> thriftRet = ks.getCounterSlice(ThriftSliceCounterQuery.this.keySerializer.toByteBuffer(ThriftSliceCounterQuery.this.key), columnParent, ThriftSliceCounterQuery.this.getPredicate());
                return new CounterSliceImpl(thriftRet, ThriftSliceCounterQuery.this.columnNameSerializer);
            }
        }), this);
    }

    public String toString() {
        return "CounterSliceQuery(" + this.key + "," + this.toStringInternal() + ")";
    }

    @Override
    public SliceCounterQuery<K, N> setColumnNames(N ... columnNames) {
        return (SliceCounterQuery)super.setColumnNames(columnNames);
    }

    @Override
    public SliceCounterQuery<K, N> setRange(N start, N finish, boolean reversed, int count) {
        return (SliceCounterQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public SliceCounterQuery<K, N> setColumnFamily(String cf) {
        return (SliceCounterQuery)super.setColumnFamily(cf);
    }
}

