/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.mgt;

import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.streaming.StreamingServiceMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.mgt.CassandraServerManagementException;

public class CassandraMBeanLocator {
    private static final Log log = LogFactory.getLog(CassandraMBeanLocator.class);
    private MBeanServerConnection mBeanServerConnection;
    private static final String SS_OBJECT_NAME = "org.apache.cassandra.db:type=StorageService";
    private StorageServiceMBean storageServiceProxy;
    private StreamingServiceMBean streamProxy;
    private CompactionManagerMBean compactionProxy;
    private ColumnFamilyStoreMBean columnFamilyStoreMBean;

    public CassandraMBeanLocator(MBeanServerConnection mBeanServerConnection) {
        this.mBeanServerConnection = mBeanServerConnection;
    }

    public StorageServiceMBean locateStorageServiceMBean() throws CassandraServerManagementException {
        if (this.storageServiceProxy == null) {
            this.storageServiceProxy = this.locateMBean(SS_OBJECT_NAME, StorageServiceMBean.class);
        }
        return this.storageServiceProxy;
    }

    public StreamingServiceMBean locateStreamingServiceMBean() throws CassandraServerManagementException {
        if (this.streamProxy == null) {
            this.streamProxy = this.locateMBean("org.apache.cassandra.net:type=StreamingService", StreamingServiceMBean.class);
        }
        return this.streamProxy;
    }

    public CompactionManagerMBean locateCompactionManagerMBean() throws CassandraServerManagementException {
        if (this.compactionProxy == null) {
            this.compactionProxy = this.locateMBean("org.apache.cassandra.db:type=CompactionManager", CompactionManagerMBean.class);
        }
        return this.compactionProxy;
    }

    public ColumnFamilyStoreMBean locateColumnFamilyStoreMBean(String ks, String cf) throws CassandraServerManagementException {
        if (this.columnFamilyStoreMBean == null) {
            this.columnFamilyStoreMBean = this.locateMBean("org.apache.cassandra.db:type=ColumnFamilies,keyspace=" + ks + ",columnfamily=" + cf, ColumnFamilyStoreMBean.class);
        }
        return this.columnFamilyStoreMBean;
    }

    private <T> T locateMBean(String name, Class<T> mBeanClass) throws CassandraServerManagementException {
        try {
            return JMX.newMBeanProxy(this.mBeanServerConnection, new ObjectName(name), mBeanClass);
        }
        catch (MalformedObjectNameException e) {
            throw new CassandraServerManagementException("Invalid ObjectName? Please report this as a bug.", e, log);
        }
    }
}

