/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.mgt;

import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.mgt.CassandraMBeanLocator;
import org.wso2.carbon.cassandra.mgt.CassandraServerManagementException;
import org.wso2.carbon.cassandra.mgt.ColumnFamilyStats;
import org.wso2.carbon.cassandra.mgt.NodeInformation;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;

public class CassandraClusterAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(CassandraClusterAdmin.class);
    private CassandraMBeanLocator cassandraMBeanLocator = new CassandraMBeanLocator(ManagementFactory.getPlatformMBeanServer());

    public NodeInformation[] getNodes() throws CassandraServerManagementException {
        StorageServiceMBean storageServiceMBean = this.cassandraMBeanLocator.locateStorageServiceMBean();
        Map tokenToEndpoint = storageServiceMBean.getTokenToEndpointMap();
        ArrayList sortedTokens = new ArrayList(tokenToEndpoint.keySet());
        Collections.sort(sortedTokens);
        List liveNodes = storageServiceMBean.getLiveNodes();
        List deadNodes = storageServiceMBean.getUnreachableNodes();
        List joiningNodes = storageServiceMBean.getJoiningNodes();
        List leavingNodes = storageServiceMBean.getLeavingNodes();
        Map loadMap = storageServiceMBean.getLoadMap();
        ArrayList<NodeInformation> nodeInformations = new ArrayList<NodeInformation>();
        Map ownerships = storageServiceMBean.getOwnership();
        for (String token : sortedTokens) {
            String status;
            String primaryEndpoint = (String)tokenToEndpoint.get(token);
            String string = liveNodes.contains(primaryEndpoint) ? "Up" : (status = deadNodes.contains(primaryEndpoint) ? "Down" : "?");
            String state = joiningNodes.contains(primaryEndpoint) ? "Joining" : (leavingNodes.contains(primaryEndpoint) ? "Leaving" : "Normal");
            String load = loadMap.containsKey(primaryEndpoint) ? (String)loadMap.get(primaryEndpoint) : "?";
            String owns = new DecimalFormat("##0.00%").format(ownerships.get(token));
            NodeInformation nodeInformation = new NodeInformation();
            nodeInformation.setAddress(primaryEndpoint);
            nodeInformation.setState(state);
            nodeInformation.setStatus(status);
            nodeInformation.setOwn(owns);
            nodeInformation.setLoad(load);
            nodeInformation.setToken(token.toString());
            nodeInformations.add(nodeInformation);
        }
        return nodeInformations.toArray(new NodeInformation[nodeInformations.size()]);
    }

    public ColumnFamilyStats getColumnFamilyStats(String keyspace, String cf) throws CassandraServerManagementException {
        ColumnFamilyStoreMBean columnFamilyStoreMBean;
        this.validateKeyspace(keyspace);
        this.validateCF(cf);
        String keyspaceWithDomainName = keyspace;
        String domainName = CarbonContext.getCurrentContext().getTenantDomain();
        if (domainName != null && !"".equals(domainName)) {
            domainName = domainName.replace(".", "_");
            keyspaceWithDomainName = domainName + "_" + keyspace;
        }
        if ((columnFamilyStoreMBean = this.cassandraMBeanLocator.locateColumnFamilyStoreMBean(keyspaceWithDomainName, cf)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot locate a ColumnFamilyStoreMBean for column family : " + cf));
            }
            return null;
        }
        ColumnFamilyStats columnFamilyStats = new ColumnFamilyStats();
        columnFamilyStats.setLiveSSTableCount(columnFamilyStoreMBean.getLiveSSTableCount());
        columnFamilyStats.setLiveDiskSpaceUsed(columnFamilyStoreMBean.getLiveDiskSpaceUsed());
        columnFamilyStats.setTotalDiskSpaceUsed(columnFamilyStoreMBean.getTotalDiskSpaceUsed());
        columnFamilyStats.setMemtableColumnsCount(columnFamilyStoreMBean.getMemtableColumnsCount());
        columnFamilyStats.setMemtableSwitchCount(columnFamilyStoreMBean.getMemtableSwitchCount());
        columnFamilyStats.setMemtableDataSize(columnFamilyStoreMBean.getMemtableDataSize());
        columnFamilyStats.setReadCount(columnFamilyStoreMBean.getReadCount());
        columnFamilyStats.setReadLatency(columnFamilyStoreMBean.getRecentReadLatencyMicros());
        columnFamilyStats.setWriteCount(columnFamilyStoreMBean.getWriteCount());
        columnFamilyStats.setWriteLatency(columnFamilyStoreMBean.getRecentWriteLatencyMicros());
        columnFamilyStats.setPendingTasks(columnFamilyStoreMBean.getPendingTasks());
        return columnFamilyStats;
    }

    private void validateKeyspace(String keyspaceName) throws CassandraServerManagementException {
        if (keyspaceName == null || "".equals(keyspaceName.trim())) {
            throw new CassandraServerManagementException("The keyspace name is empty or null", log);
        }
    }

    private void validateCF(String columnFamilyName) throws CassandraServerManagementException {
        if (columnFamilyName == null || "".equals(columnFamilyName.trim())) {
            throw new CassandraServerManagementException("The column family name is empty or null", log);
        }
    }
}

