/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.mgt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.cassandra.dataaccess.DataAccessService;
import org.wso2.carbon.cassandra.mgt.CassandraServerManagementException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class CassandraAdminComponentManager {
    private static Log log = LogFactory.getLog(CassandraAdminComponentManager.class);
    private static CassandraAdminComponentManager ourInstance = new CassandraAdminComponentManager();
    private DataAccessService dataAccessService;
    private RealmService realmService;
    private boolean initialized = false;
    private ConfigurationContextService configCtxService;
    private ServerConfigurationService serverConfigurationService;

    public static CassandraAdminComponentManager getInstance() {
        return ourInstance;
    }

    private CassandraAdminComponentManager() {
    }

    public void init(DataAccessService dataAccessService, RealmService realmService, ConfigurationContextService configCtxService, ServerConfigurationService serverConfigurationService) {
        this.dataAccessService = dataAccessService;
        this.realmService = realmService;
        this.configCtxService = configCtxService;
        this.serverConfigurationService = serverConfigurationService;
        this.initialized = true;
    }

    public DataAccessService getDataAccessService() throws CassandraServerManagementException {
        this.assertInitialized();
        return this.dataAccessService;
    }

    public ConfigurationContextService getConfigurationContextService() throws CassandraServerManagementException {
        this.assertInitialized();
        return this.configCtxService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void assertInitialized() throws CassandraServerManagementException {
        if (!this.initialized) {
            throw new CassandraServerManagementException("Cassandra Admin Component has not been initialized", log);
        }
    }

    public UserRealm getRealmForCurrentTenant() throws CassandraServerManagementException {
        this.assertInitialized();
        try {
            return this.realmService.getTenantUserRealm(CarbonContext.getCurrentContext().getTenantId());
        }
        catch (UserStoreException e) {
            throw new CassandraServerManagementException("Error accessing the UserRealm for super tenant : " + (Object)((Object)e), log);
        }
    }

    public void destroy() {
        this.realmService = null;
        this.dataAccessService = null;
        this.initialized = false;
    }
}

