/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.mgt.ui;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.mgt.stub.cluster.CassandraClusterAdminStub;
import org.wso2.carbon.cassandra.mgt.stub.cluster.xsd.ColumnFamilyStats;
import org.wso2.carbon.cassandra.mgt.stub.cluster.xsd.NodeInformation;
import org.wso2.carbon.cassandra.mgt.ui.CassandraAdminClientException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class CassandraClusterAdminClient {
    private static final Log log = LogFactory.getLog(CassandraClusterAdminClient.class);
    private CassandraClusterAdminStub cassandraAdminStub;

    public CassandraClusterAdminClient(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        this.init(ctx, serverURL, cookie);
    }

    public CassandraClusterAdminClient(ServletContext servletContext, HttpSession httpSession) throws Exception {
        ConfigurationContext ctx = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String cookie = (String)httpSession.getAttribute("wso2carbon.admin.service.cookie");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)httpSession);
        this.init(ctx, serverURL, cookie);
    }

    private void init(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        String serviceURL = serverURL + "CassandraClusterAdmin";
        this.cassandraAdminStub = new CassandraClusterAdminStub(ctx, serviceURL);
        ServiceClient client = this.cassandraAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        options.setProperty("enableMTOM", (Object)"true");
        options.setTimeOutInMilliSeconds(10000L);
    }

    public NodeInformation[] listNodes() throws CassandraAdminClientException {
        try {
            return this.cassandraAdminStub.getNodes();
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error retrieving nodes names !", e, log);
        }
    }

    public ColumnFamilyStats getColumnFamilyStats(String keyspace, String cf) {
        this.validateKeyspace(keyspace);
        this.validateCF(cf);
        try {
            return this.cassandraAdminStub.getColumnFamilyStats(keyspace, cf);
        }
        catch (Exception e) {
            log.error((Object)"Error retrieving nodes names !", (Throwable)e);
            return null;
        }
    }

    private void validateKeyspace(String keyspaceName) throws CassandraAdminClientException {
        if (keyspaceName == null || "".equals(keyspaceName.trim())) {
            throw new CassandraAdminClientException("The keyspace name is empty or null", log);
        }
    }

    private void validateCF(String columnFamilyName) throws CassandraAdminClientException {
        if (columnFamilyName == null || "".equals(columnFamilyName.trim())) {
            throw new CassandraAdminClientException("The column family name name is empty or null", log);
        }
    }
}

