/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.mgt.ui;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.mgt.stub.ks.CassandraKeyspaceAdminStub;
import org.wso2.carbon.cassandra.mgt.stub.ks.xsd.ColumnFamilyInformation;
import org.wso2.carbon.cassandra.mgt.stub.ks.xsd.KeyspaceInformation;
import org.wso2.carbon.cassandra.mgt.stub.ks.xsd.TokenRangeInformation;
import org.wso2.carbon.cassandra.mgt.ui.CassandraAdminClientException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class CassandraKeyspaceAdminClient {
    private static final Log log = LogFactory.getLog(CassandraKeyspaceAdminClient.class);
    private CassandraKeyspaceAdminStub cassandraAdminStub;

    public CassandraKeyspaceAdminClient(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        this.init(ctx, serverURL, cookie);
    }

    public CassandraKeyspaceAdminClient(ServletContext servletContext, HttpSession httpSession) throws Exception {
        ConfigurationContext ctx = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String cookie = (String)httpSession.getAttribute("wso2carbon.admin.service.cookie");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)httpSession);
        this.init(ctx, serverURL, cookie);
    }

    private void init(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        String serviceURL = serverURL + "CassandraKeyspaceAdmin";
        this.cassandraAdminStub = new CassandraKeyspaceAdminStub(ctx, serviceURL);
        ServiceClient client = this.cassandraAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        options.setProperty("enableMTOM", (Object)"true");
        options.setTimeOutInMilliSeconds(10000L);
    }

    public String getClusterName() throws CassandraAdminClientException {
        try {
            return this.cassandraAdminStub.getClusterName();
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error retrieving Cluster Name !", e, log);
        }
    }

    public String[] lisKeyspaces(String clusterName, String username, String password) throws CassandraAdminClientException {
        try {
            return this.cassandraAdminStub.listKeyspaces(clusterName, username, password);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error retrieving keyspace names !", e, log);
        }
    }

    public String[] listKeyspacesOfCurrentUSer() throws CassandraAdminClientException {
        try {
            return this.cassandraAdminStub.listKeyspacesOfCurrentUser();
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error retrieving keyspace names !", e, log);
        }
    }

    public String[] listColumnFamiliesOfCurrentUser(String keyspaceName) throws CassandraAdminClientException {
        this.validateKeyspace(keyspaceName);
        try {
            return this.cassandraAdminStub.listColumnFamiliesOfCurrentUser(keyspaceName);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error retrieving CF names !", e, log);
        }
    }

    public ColumnFamilyInformation getColumnFamilyInformationOfCurrentUser(String keyspaceName, String cfName) throws CassandraAdminClientException {
        this.validateKeyspace(keyspaceName);
        this.validateCF(cfName);
        try {
            return this.cassandraAdminStub.getColumnFamilyOfCurrentUser(keyspaceName, cfName);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error retrieving the CF for the name " + cfName, e, log);
        }
    }

    public boolean shareResource(String role, String path) throws CassandraAdminClientException {
        try {
            return this.cassandraAdminStub.shareResource(role, path);
        }
        catch (Throwable e) {
            throw new CassandraAdminClientException("Error sharing a resource !", e, log);
        }
    }

    public boolean shareResourceRead(String role, String path) throws CassandraAdminClientException {
        try {
            return this.cassandraAdminStub.shareResourceRead(role, path);
        }
        catch (Throwable e) {
            throw new CassandraAdminClientException("Error sharing a resource !", e, log);
        }
    }

    public boolean shareResourceWrite(String role, String path) throws CassandraAdminClientException {
        try {
            return this.cassandraAdminStub.shareResourceWrite(role, path);
        }
        catch (Throwable e) {
            throw new CassandraAdminClientException("Error sharing a resource !", e, log);
        }
    }

    public boolean clearResource(String role, String path) throws CassandraAdminClientException {
        try {
            return this.cassandraAdminStub.clearResource(role, path);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error clear authorization for a resource !", e, log);
        }
    }

    public KeyspaceInformation getKeyspaceOfCurrentUser(String keyspaceName) throws CassandraAdminClientException {
        this.validateKeyspace(keyspaceName);
        try {
            return this.cassandraAdminStub.getKeyspaceofCurrentUser(keyspaceName);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error retrieving keyspace !", e, log);
        }
    }

    public void addKeyspace(KeyspaceInformation keyspaceInformation) throws CassandraAdminClientException {
        this.validateKeyspaceInformation(keyspaceInformation);
        try {
            this.cassandraAdminStub.addKeyspace(keyspaceInformation);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error adding the keyspace !", e, log);
        }
    }

    public void updateKeyspace(KeyspaceInformation keyspaceInformation) throws CassandraAdminClientException {
        this.validateKeyspaceInformation(keyspaceInformation);
        try {
            this.cassandraAdminStub.updatedKeyspace(keyspaceInformation);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error updating the keyspace !", e, log);
        }
    }

    public String[] getAllRoles() throws CassandraAdminClientException {
        try {
            return this.cassandraAdminStub.getAllRoles();
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error retrieving user names !", e, log);
        }
    }

    public boolean deleteKeyspace(String keyspaceName) throws CassandraAdminClientException {
        this.validateKeyspace(keyspaceName);
        try {
            return this.cassandraAdminStub.deleteKeyspace(keyspaceName);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error removing the keyspace !", e, log);
        }
    }

    public boolean deleteColumnFamily(String keyspaceName, String columnFamilyName) throws CassandraAdminClientException {
        this.validateKeyspace(keyspaceName);
        this.validateCF(columnFamilyName);
        try {
            return this.cassandraAdminStub.deleteColumnFamily(keyspaceName, columnFamilyName);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error removing the CF !", e, log);
        }
    }

    public void addColumnFamily(ColumnFamilyInformation columnFamilyInformation) throws CassandraAdminClientException {
        this.validateColumnFamilyInformation(columnFamilyInformation);
        try {
            this.cassandraAdminStub.addColumnFamily(columnFamilyInformation);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error adding the CF !", e, log);
        }
    }

    public void updateColumnFamily(ColumnFamilyInformation columnFamilyInformation) throws CassandraAdminClientException {
        this.validateColumnFamilyInformation(columnFamilyInformation);
        try {
            this.cassandraAdminStub.updateColumnFamily(columnFamilyInformation);
        }
        catch (Exception e) {
            throw new CassandraAdminClientException("Error updating the CF !", e, log);
        }
    }

    public TokenRangeInformation[] getTokenRange(String keyspace) throws CassandraAdminClientException {
        this.validateKeyspace(keyspace);
        try {
            return this.cassandraAdminStub.getTokenRange(keyspace);
        }
        catch (Exception e) {
            log.error((Object)("Error getting the token range of the keyspace : " + keyspace), (Throwable)e);
            return null;
        }
    }

    public String[] getKeyspaceSharedRolesWrite(String path) {
        try {
            return this.cassandraAdminStub.getKeyspaceSharedRolesWrite(path);
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving role list" + path), (Throwable)e);
            return null;
        }
    }

    public String[] getKeyspaceSharedRolesRead(String path) {
        try {
            return this.cassandraAdminStub.getKeyspaceSharedRolesRead(path);
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving role list" + path), (Throwable)e);
            return null;
        }
    }

    private void validateKeyspace(String keyspaceName) throws CassandraAdminClientException {
        if (keyspaceName == null || "".equals(keyspaceName.trim())) {
            throw new CassandraAdminClientException("The keyspace name is empty or null", log);
        }
    }

    private void validateKeyspaceInformation(KeyspaceInformation keyspaceInformation) throws CassandraAdminClientException {
        if (keyspaceInformation == null) {
            throw new CassandraAdminClientException("The keyspace information is empty or null", log);
        }
        this.validateKeyspace(keyspaceInformation.getName());
    }

    private void validateColumnFamilyInformation(ColumnFamilyInformation columnFamilyInformation) throws CassandraAdminClientException {
        if (columnFamilyInformation == null) {
            throw new CassandraAdminClientException("The column family information is empty or null", log);
        }
        this.validateKeyspace(columnFamilyInformation.getKeyspace());
        this.validateCF(columnFamilyInformation.getName());
    }

    private void validateCF(String columnFamilyName) throws CassandraAdminClientException {
        if (columnFamilyName == null || "".equals(columnFamilyName.trim())) {
            throw new CassandraAdminClientException("The column family name name is empty or null", log);
        }
    }
}

