/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.mgt;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import me.prettyprint.cassandra.model.BasicColumnDefinition;
import me.prettyprint.cassandra.model.BasicColumnFamilyDefinition;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.ThriftCfDef;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ddl.ColumnDefinition;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ColumnIndexType;
import me.prettyprint.hector.api.ddl.ColumnType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.cassandra.dataaccess.ClusterInformation;
import org.wso2.carbon.cassandra.dataaccess.DataAccessService;
import org.wso2.carbon.cassandra.mgt.CassandraAdminComponentManager;
import org.wso2.carbon.cassandra.mgt.CassandraServerManagementException;
import org.wso2.carbon.cassandra.mgt.ColumnFamilyInformation;
import org.wso2.carbon.cassandra.mgt.ColumnInformation;
import org.wso2.carbon.cassandra.mgt.KeyspaceInformation;
import org.wso2.carbon.cassandra.mgt.TokenRangeInformation;
import org.wso2.carbon.cassandra.mgt.internal.CassandraAdminDSComponent;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class CassandraKeyspaceAdmin
extends AbstractAdmin {
    private static final String ACTION_WRITE = "write";
    private static final String ACTION_READ = "read";
    private static final String KEYSPACE_SYSTEM = "system";
    private static final String USER_ACCESSKEY_ATTR_NAME = "cassandra.user.password";
    private static final String CASSANDRA_AUTH_USER = "admin";
    private static final String CASSANDRA_AUTH_PASSWORD = "admin";
    private static final String CASSANDRA_AUTH_SERVICE = "CassandraSharedKeyPublisher";
    private static final String CASSANDRA_AUTH_CONF = "repository" + File.separator + "conf" + File.separator + "etc" + File.separator + "cassandra-auth.xml";
    private static String CARBON_CONFIG_PORT_OFFSET = "Ports.Offset";
    private static int CARBON_DEFAULT_PORT_OFFSET = 0;
    private static final Log log = LogFactory.getLog(CassandraKeyspaceAdmin.class);

    public String getClusterName() throws CassandraServerManagementException {
        Cluster cluster = this.getCluster(null);
        return cluster.getClusterName();
    }

    public String[] listKeyspaces(String clusterName, String username, String password) throws CassandraServerManagementException {
        if (username == null || "".equals(username.trim())) {
            throw new CassandraServerManagementException("The username is empty or null", log);
        }
        if (password == null || "".equals(password.trim())) {
            throw new CassandraServerManagementException("The password is empty or null", log);
        }
        ClusterInformation clusterInformation = new ClusterInformation(username.trim(), password.trim());
        clusterInformation.setClusterName(clusterName);
        return this.getKeyspaces(clusterInformation);
    }

    public String[] listKeyspacesOfCurrentUser() throws CassandraServerManagementException {
        return this.getKeyspaces(null);
    }

    public String[] listColumnFamiliesOfCurrentUser(String keyspaceName) throws CassandraServerManagementException {
        KeyspaceDefinition keyspaceDefinition = this.getKeyspaceDefinition(keyspaceName);
        ArrayList<String> cfNames = new ArrayList<String>();
        for (ColumnFamilyDefinition columnFamilyDefinition : keyspaceDefinition.getCfDefs()) {
            String name = columnFamilyDefinition.getName();
            if (name == null || "".equals(name)) continue;
            cfNames.add(name);
        }
        return cfNames.toArray(new String[cfNames.size()]);
    }

    public KeyspaceInformation getKeyspaceofCurrentUser(String keyspaceName) throws CassandraServerManagementException {
        KeyspaceDefinition keyspaceDefinition = this.getKeyspaceDefinition(keyspaceName);
        KeyspaceInformation keyspaceInformation = new KeyspaceInformation(keyspaceDefinition.getName());
        keyspaceInformation.setStrategyClass(keyspaceDefinition.getStrategyClass());
        keyspaceInformation.setReplicationFactor(keyspaceDefinition.getReplicationFactor());
        ArrayList<ColumnFamilyInformation> columnFamilyInformations = new ArrayList<ColumnFamilyInformation>();
        for (ColumnFamilyDefinition definition : keyspaceDefinition.getCfDefs()) {
            if (definition == null) continue;
            columnFamilyInformations.add(this.createColumnFamilyInformation(definition));
        }
        keyspaceInformation.setColumnFamilies(columnFamilyInformations.toArray(new ColumnFamilyInformation[columnFamilyInformations.size()]));
        return keyspaceInformation;
    }

    public ColumnFamilyInformation getColumnFamilyOfCurrentUser(String keyspaceName, String columnFamilyName) throws CassandraServerManagementException {
        try {
            KeyspaceDefinition keyspaceDefinition = this.getKeyspaceDefinition(keyspaceName);
            this.validateCF(columnFamilyName);
            for (ColumnFamilyDefinition definition : keyspaceDefinition.getCfDefs()) {
                if (definition == null || !columnFamilyName.equals(definition.getName())) continue;
                return this.createColumnFamilyInformation(definition);
            }
            throw new CassandraServerManagementException("There is no column family with the name :" + columnFamilyName, log);
        }
        catch (HectorException e) {
            throw new CassandraServerManagementException("Error accessing a column family with the name :" + columnFamilyName, e, log);
        }
    }

    public boolean shareResource(String role, String path) throws CassandraServerManagementException {
        if (role == null || "".equals(role.trim())) {
            throw new CassandraServerManagementException("Username is null or empty", log);
        }
        role = role.trim();
        if (path == null || "".equals(path.trim())) {
            throw new CassandraServerManagementException("Resource path is null or empty", log);
        }
        path = path.trim();
        try {
            CassandraAdminComponentManager adminComponentManager = CassandraAdminComponentManager.getInstance();
            UserRealm userRealm = adminComponentManager.getRealmForCurrentTenant();
            AuthorizationManager authorizationManager = userRealm.getAuthorizationManager();
            authorizationManager.clearRoleAuthorization(role, path, ACTION_WRITE);
            authorizationManager.clearRoleAuthorization(role, path, ACTION_READ);
            authorizationManager.authorizeRole(role, path, ACTION_WRITE);
            authorizationManager.authorizeRole(role, path, ACTION_READ);
            return true;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CassandraServerManagementException("Error during sharing a resource at path :" + path + " and" + " for role :" + role, e, log);
        }
    }

    public boolean shareResourceRead(String role, String path) throws CassandraServerManagementException {
        if (role == null || "".equals(role.trim())) {
            throw new CassandraServerManagementException("Username is null or empty", log);
        }
        role = role.trim();
        if (path == null || "".equals(path.trim())) {
            throw new CassandraServerManagementException("Resource path is null or empty", log);
        }
        path = path.trim();
        try {
            CassandraAdminComponentManager adminComponentManager = CassandraAdminComponentManager.getInstance();
            UserRealm userRealm = adminComponentManager.getRealmForCurrentTenant();
            AuthorizationManager authorizationManager = userRealm.getAuthorizationManager();
            authorizationManager.clearRoleAuthorization(role, path, ACTION_READ);
            authorizationManager.authorizeRole(role, path, ACTION_READ);
            return true;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CassandraServerManagementException("Error during sharing a resource at path :" + path + " and" + " for role :" + role, e, log);
        }
    }

    public boolean shareResourceWrite(String role, String path) throws CassandraServerManagementException {
        if (role == null || "".equals(role.trim())) {
            throw new CassandraServerManagementException("Username is null or empty", log);
        }
        role = role.trim();
        if (path == null || "".equals(path.trim())) {
            throw new CassandraServerManagementException("Resource path is null or empty", log);
        }
        path = path.trim();
        try {
            CassandraAdminComponentManager adminComponentManager = CassandraAdminComponentManager.getInstance();
            UserRealm userRealm = adminComponentManager.getRealmForCurrentTenant();
            AuthorizationManager authorizationManager = userRealm.getAuthorizationManager();
            authorizationManager.clearRoleAuthorization(role, path, ACTION_WRITE);
            authorizationManager.authorizeRole(role, path, ACTION_WRITE);
            return true;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CassandraServerManagementException("Error during sharing a resource at path :" + path + " and" + " for role :" + role, e, log);
        }
    }

    public boolean clearResource(String role, String path) throws CassandraServerManagementException {
        if (role == null || "".equals(role.trim())) {
            throw new CassandraServerManagementException("Username is null or empty", log);
        }
        role = role.trim();
        if (path == null || "".equals(path.trim())) {
            throw new CassandraServerManagementException("Resource path is null or empty", log);
        }
        path = path.trim();
        try {
            CassandraAdminComponentManager adminComponentManager = CassandraAdminComponentManager.getInstance();
            UserRealm userRealm = adminComponentManager.getRealmForCurrentTenant();
            AuthorizationManager authorizationManager = userRealm.getAuthorizationManager();
            authorizationManager.clearRoleAuthorization(role, path, ACTION_WRITE);
            authorizationManager.clearRoleAuthorization(role, path, ACTION_READ);
            return true;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CassandraServerManagementException("Error during clear sharing a resource at path :" + path + " and" + " for role :" + role, e, log);
        }
    }

    public boolean clearResourceRead(String role, String path) throws CassandraServerManagementException {
        if (role == null || "".equals(role.trim())) {
            throw new CassandraServerManagementException("Username is null or empty", log);
        }
        role = role.trim();
        if (path == null || "".equals(path.trim())) {
            throw new CassandraServerManagementException("Resource path is null or empty", log);
        }
        path = path.trim();
        try {
            CassandraAdminComponentManager adminComponentManager = CassandraAdminComponentManager.getInstance();
            UserRealm userRealm = adminComponentManager.getRealmForCurrentTenant();
            AuthorizationManager authorizationManager = userRealm.getAuthorizationManager();
            authorizationManager.clearRoleAuthorization(role, path, ACTION_READ);
            return true;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CassandraServerManagementException("Error during clear sharing a resource at path :" + path + " and" + " for role :" + role, e, log);
        }
    }

    public boolean clearResourceWrite(String role, String path) throws CassandraServerManagementException {
        if (role == null || "".equals(role.trim())) {
            throw new CassandraServerManagementException("Username is null or empty", log);
        }
        role = role.trim();
        if (path == null || "".equals(path.trim())) {
            throw new CassandraServerManagementException("Resource path is null or empty", log);
        }
        path = path.trim();
        try {
            CassandraAdminComponentManager adminComponentManager = CassandraAdminComponentManager.getInstance();
            UserRealm userRealm = adminComponentManager.getRealmForCurrentTenant();
            AuthorizationManager authorizationManager = userRealm.getAuthorizationManager();
            authorizationManager.clearRoleAuthorization(role, path, ACTION_WRITE);
            return true;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CassandraServerManagementException("Error during clear sharing a resource at path :" + path + " and" + " for role :" + role, e, log);
        }
    }

    public void addKeyspace(KeyspaceInformation keyspaceInformation) throws CassandraServerManagementException {
        this.validateKeyspaceInformation(keyspaceInformation);
        this.addOrUpdateKeyspace(true, keyspaceInformation.getName(), keyspaceInformation.getReplicationFactor(), keyspaceInformation.getStrategyClass());
    }

    public void updatedKeyspace(KeyspaceInformation keyspaceInformation) throws CassandraServerManagementException {
        this.validateKeyspaceInformation(keyspaceInformation);
        this.addOrUpdateKeyspace(false, keyspaceInformation.getName(), keyspaceInformation.getReplicationFactor(), keyspaceInformation.getStrategyClass());
    }

    public String[] getAllRoles() throws CassandraServerManagementException {
        try {
            return super.getUserRealm().getUserStoreManager().getRoleNames();
        }
        catch (UserStoreException e) {
            throw new CassandraServerManagementException("Error loading all the users", e, log);
        }
    }

    public String[] getKeyspaceSharedRolesRead(String path) throws CassandraServerManagementException {
        try {
            CassandraAdminComponentManager adminComponentManager = CassandraAdminComponentManager.getInstance();
            UserRealm userRealm = adminComponentManager.getRealmForCurrentTenant();
            AuthorizationManager authorizationManager = userRealm.getAuthorizationManager();
            String[] readAllowedRoles = authorizationManager.getAllowedRolesForResource(path, ACTION_READ);
            return readAllowedRoles;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CassandraServerManagementException("Error retrieving role list for :" + path, e, log);
        }
    }

    public String[] getKeyspaceSharedRolesWrite(String path) throws CassandraServerManagementException {
        try {
            CassandraAdminComponentManager adminComponentManager = CassandraAdminComponentManager.getInstance();
            UserRealm userRealm = adminComponentManager.getRealmForCurrentTenant();
            AuthorizationManager authorizationManager = userRealm.getAuthorizationManager();
            String[] writeAllowedRoles = authorizationManager.getAllowedRolesForResource(path, ACTION_WRITE);
            return writeAllowedRoles;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new CassandraServerManagementException("Error retrieving role list for :" + path, e, log);
        }
    }

    public boolean deleteKeyspace(String keyspaceName) throws CassandraServerManagementException {
        this.validateKeyspace(keyspaceName);
        try {
            Cluster cluster = this.getCluster(null);
            cluster.dropKeyspace(keyspaceName.trim());
        }
        catch (HectorException e) {
            throw new CassandraServerManagementException("Error removing a keyspace with the name :" + keyspaceName, e, log);
        }
        return true;
    }

    public void addColumnFamily(ColumnFamilyInformation columnFamilyInformation) throws CassandraServerManagementException {
        this.addOrUpdateCF(true, columnFamilyInformation);
    }

    public void updateColumnFamily(ColumnFamilyInformation columnFamilyInformation) throws CassandraServerManagementException {
        this.addOrUpdateCF(false, columnFamilyInformation);
    }

    public boolean deleteColumnFamily(String keyspaceName, String columnFamilyName) throws CassandraServerManagementException {
        this.validateKeyspace(keyspaceName);
        this.validateCF(columnFamilyName);
        try {
            Cluster cluster = this.getCluster(null);
            cluster.dropColumnFamily(keyspaceName.trim(), columnFamilyName.trim());
        }
        catch (HectorException e) {
            throw new CassandraServerManagementException("Error removing a column family with the name :" + columnFamilyName, e, log);
        }
        return true;
    }

    public TokenRangeInformation[] getTokenRange(String keyspace) throws CassandraServerManagementException {
        this.validateKeyspace(keyspace);
        ThriftCluster thriftCluster = (ThriftCluster)this.getCluster(null);
        Set cassandraHosts = thriftCluster.getKnownPoolHosts(true);
        int rpcPort = 9160;
        for (CassandraHost cassandraHost : cassandraHosts) {
            if (cassandraHost == null) continue;
            rpcPort = cassandraHost.getPort();
            break;
        }
        ArrayList<TokenRangeInformation> tokenRangeInformations = new ArrayList<TokenRangeInformation>();
        if (!KEYSPACE_SYSTEM.equals(keyspace)) {
            List tokenRanges = thriftCluster.describeRing(keyspace);
            for (TokenRange tokenRange : tokenRanges) {
                if (tokenRange == null) continue;
                TokenRangeInformation tokenRangeInformation = new TokenRangeInformation();
                tokenRangeInformation.setStartToken(tokenRange.getStart_token());
                tokenRangeInformation.setEndToken(tokenRange.getEnd_token());
                ArrayList<String> eps = new ArrayList<String>();
                for (String ep : tokenRange.getEndpoints()) {
                    if (ep == null || "".equals(ep.trim())) continue;
                    eps.add(ep + ":" + rpcPort);
                }
                if (!eps.isEmpty()) {
                    tokenRangeInformation.setEndpoints(eps.toArray(new String[eps.size()]));
                }
                tokenRangeInformations.add(tokenRangeInformation);
            }
        }
        return tokenRangeInformations.toArray(new TokenRangeInformation[tokenRangeInformations.size()]);
    }

    private String[] getKeyspaces(ClusterInformation clusterInformation) throws CassandraServerManagementException {
        Cluster cluster = this.getCluster(clusterInformation);
        ArrayList<String> keyspaceNames = new ArrayList<String>();
        for (KeyspaceDefinition keyspaceDefinition : cluster.describeKeyspaces()) {
            String name = keyspaceDefinition.getName();
            if (name == null || "".equals(name)) continue;
            keyspaceNames.add(name);
        }
        return keyspaceNames.toArray(new String[keyspaceNames.size()]);
    }

    private Cluster getCluster(ClusterInformation clusterInformation) throws CassandraServerManagementException {
        DataAccessService dataAccessService = CassandraAdminComponentManager.getInstance().getDataAccessService();
        boolean resetConnection = true;
        try {
            Cluster cluster;
            if (clusterInformation != null) {
                cluster = dataAccessService.getCluster(clusterInformation, resetConnection);
            } else {
                String sharedKey = this.getSharedKey();
                cluster = dataAccessService.getClusterForCurrentUser(sharedKey, resetConnection);
            }
            return cluster;
        }
        catch (Throwable e) {
            super.getHttpSession().removeAttribute(USER_ACCESSKEY_ATTR_NAME);
            String message = "Error getting cluster";
            throw new CassandraServerManagementException(message, log);
        }
    }

    private void addOrUpdateKeyspace(boolean isAdd, String keyspaceName, int replicationFactor, String replicationStrategy) throws CassandraServerManagementException {
        Cluster cluster = this.getCluster(null);
        try {
            KeyspaceDefinition definition = HFactory.createKeyspaceDefinition((String)keyspaceName.trim(), (String)replicationStrategy, (int)replicationFactor, null);
            if (isAdd) {
                cluster.addKeyspace(definition);
            } else {
                cluster.updateKeyspace(definition);
            }
        }
        catch (HectorException e) {
            throw new CassandraServerManagementException("Error " + (isAdd ? "adding" : "updating") + " a keyspace" + " with name :" + keyspaceName, e, log);
        }
    }

    private void addOrUpdateCF(boolean isAdd, ColumnFamilyInformation columnFamilyInformation) throws CassandraServerManagementException {
        ColumnInformation[] columns;
        String keyspaceName = columnFamilyInformation.getKeyspace();
        String columnFamilyName = columnFamilyInformation.getName();
        this.validateKeyspace(keyspaceName);
        this.validateCF(columnFamilyName);
        ColumnType columnType = ColumnType.STANDARD;
        String type = columnFamilyInformation.getType();
        if (type != null && !"".equals(type.trim())) {
            columnType = ColumnType.getFromValue((String)type.trim());
        }
        BasicColumnFamilyDefinition familyDefinition = new BasicColumnFamilyDefinition();
        familyDefinition.setColumnType(columnType);
        familyDefinition.setId(columnFamilyInformation.getId());
        familyDefinition.setName(columnFamilyName);
        familyDefinition.setKeyspaceName(keyspaceName);
        familyDefinition.setKeyCacheSize(columnFamilyInformation.getKeyCacheSize());
        familyDefinition.setComment(columnFamilyInformation.getComment());
        familyDefinition.setGcGraceSeconds(columnFamilyInformation.getGcGraceSeconds());
        familyDefinition.setRowCacheSize(columnFamilyInformation.getRowCacheSize());
        familyDefinition.setReadRepairChance(columnFamilyInformation.getReadRepairChance());
        familyDefinition.setComparatorType(ComparatorType.getByClassName((String)columnFamilyInformation.getComparatorType()));
        if (ColumnType.SUPER == columnType) {
            familyDefinition.setSubComparatorType(ComparatorType.getByClassName((String)columnFamilyInformation.getSubComparatorType()));
        } else {
            familyDefinition.setSubComparatorType(null);
        }
        familyDefinition.setMaxCompactionThreshold(columnFamilyInformation.getMaxCompactionThreshold());
        familyDefinition.setMinCompactionThreshold(columnFamilyInformation.getMinCompactionThreshold());
        String defaultValidationClass = columnFamilyInformation.getDefaultValidationClass();
        if (defaultValidationClass != null && !"".equals(defaultValidationClass.trim())) {
            familyDefinition.setDefaultValidationClass(defaultValidationClass.trim());
        }
        if ((columns = columnFamilyInformation.getColumns()) != null && columns.length > 0) {
            for (ColumnInformation column : columns) {
                String indexType;
                String validationClass;
                this.validateColumnInformation(column);
                BasicColumnDefinition columnDefinition = new BasicColumnDefinition();
                columnDefinition.setName(StringSerializer.get().toByteBuffer(column.getName().trim()));
                String indexName = column.getIndexName();
                if (indexName != null && !"".equals(indexName.trim())) {
                    columnDefinition.setIndexName(indexName.trim());
                }
                if ((validationClass = column.getValidationClass()) != null && !"".equals(validationClass.trim())) {
                    columnDefinition.setValidationClass(validationClass.trim());
                }
                if ((indexType = column.getIndexType()) != null && !"".equals(indexType.trim())) {
                    columnDefinition.setIndexType(ColumnIndexType.valueOf((String)indexType.trim().toUpperCase()));
                }
                familyDefinition.addColumnDefinition((ColumnDefinition)columnDefinition);
            }
        }
        try {
            Cluster cluster = this.getCluster(null);
            if (isAdd) {
                cluster.addColumnFamily((ColumnFamilyDefinition)new ThriftCfDef((ColumnFamilyDefinition)familyDefinition));
            } else {
                cluster.updateColumnFamily((ColumnFamilyDefinition)new ThriftCfDef((ColumnFamilyDefinition)familyDefinition));
            }
        }
        catch (HectorException e) {
            throw new CassandraServerManagementException("Error " + (isAdd ? "adding" : "updating ") + " a column family with" + " the name :" + columnFamilyName, e, log);
        }
    }

    private void validateKeyspaceInformation(KeyspaceInformation information) throws CassandraServerManagementException {
        if (information == null) {
            throw new CassandraServerManagementException("The keyspace information is null", log);
        }
        this.validateKeyspace(information.getName());
    }

    private void validateColumnInformation(ColumnInformation information) throws CassandraServerManagementException {
        if (information == null) {
            throw new CassandraServerManagementException("The column information is null", log);
        }
        String name = information.getName();
        if (name == null || "".equals(name.trim())) {
            throw new CassandraServerManagementException("The column name is null", log);
        }
    }

    private void validateKeyspace(String keyspaceName) throws CassandraServerManagementException {
        if (keyspaceName == null || "".equals(keyspaceName.trim())) {
            throw new CassandraServerManagementException("The keyspace name is empty or null", log);
        }
    }

    private void validateCF(String columnFamilyName) throws CassandraServerManagementException {
        if (columnFamilyName == null || "".equals(columnFamilyName.trim())) {
            throw new CassandraServerManagementException("The column family name is empty or null", log);
        }
    }

    private KeyspaceDefinition getKeyspaceDefinition(String keyspace) throws CassandraServerManagementException {
        this.validateKeyspace(keyspace);
        Cluster cluster = this.getCluster(null);
        KeyspaceDefinition keyspaceDefinition = cluster.describeKeyspace(keyspace.trim());
        if (keyspaceDefinition == null) {
            throw new CassandraServerManagementException("Cannot find a keyspace for : " + keyspace, log);
        }
        return keyspaceDefinition;
    }

    private ColumnFamilyInformation createColumnFamilyInformation(ColumnFamilyDefinition definition) throws CassandraServerManagementException {
        int maxThreshold;
        ColumnFamilyInformation information = new ColumnFamilyInformation(definition.getKeyspaceName(), definition.getName());
        information.setId(definition.getId());
        information.setComment(definition.getComment());
        information.setComparatorType(definition.getComparatorType().getClassName());
        information.setKeyCacheSize(definition.getKeyCacheSize());
        int gcGrace = definition.getGcGraceSeconds();
        if (gcGrace > 0) {
            information.setGcGraceSeconds(gcGrace);
        }
        if ((maxThreshold = definition.getMaxCompactionThreshold()) > 0) {
            information.setMaxCompactionThreshold(maxThreshold);
        }
        int minThreshold = definition.getMinCompactionThreshold();
        if (maxThreshold > 0) {
            information.setMinCompactionThreshold(minThreshold);
        }
        information.setReadRepairChance(definition.getReadRepairChance());
        information.setRowCacheSavePeriodInSeconds(definition.getRowCacheSavePeriodInSeconds());
        information.setType(definition.getColumnType().getValue());
        information.setRowCacheSize(definition.getRowCacheSize());
        information.setDefaultValidationClass(definition.getDefaultValidationClass());
        List columnDefinitions = definition.getColumnMetadata();
        ColumnInformation[] columnInformations = new ColumnInformation[columnDefinitions.size()];
        int index = 0;
        for (ColumnDefinition column : columnDefinitions) {
            if (column == null) {
                throw new CassandraServerManagementException("Column cannot be null", log);
            }
            ByteBuffer byteBuffer = column.getName();
            if (byteBuffer == null) {
                throw new CassandraServerManagementException("Column name cannot be null", log);
            }
            byte[] byteArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byteArray);
            String name = new String(byteArray);
            if (name.isEmpty()) {
                throw new CassandraServerManagementException("Column name cannot be empty", log);
            }
            ColumnInformation columnInformation = new ColumnInformation();
            columnInformation.setName(name);
            columnInformation.setIndexName(column.getIndexName());
            columnInformation.setValidationClass(column.getValidationClass());
            ColumnIndexType columnIndexType = column.getIndexType();
            if (columnIndexType != null) {
                columnInformation.setIndexType(columnIndexType.name());
            }
            columnInformations[index] = columnInformation;
            ++index;
        }
        information.setColumns(columnInformations);
        return information;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSharedKey() throws AxisFault {
        String sharedKey = (String)super.getHttpSession().getAttribute(USER_ACCESSKEY_ATTR_NAME);
        if (sharedKey == null) {
            try {
                Class<CassandraKeyspaceAdmin> clazz = CassandraKeyspaceAdmin.class;
                synchronized (CassandraKeyspaceAdmin.class) {
                    sharedKey = (String)super.getHttpSession().getAttribute(USER_ACCESSKEY_ATTR_NAME);
                    String serverURL = this.getServerURL();
                    String epr = serverURL + CASSANDRA_AUTH_SERVICE;
                    String username = "admin";
                    String password = "admin";
                    if (sharedKey == null) {
                        if (this.isAuthConfigurationExists()) {
                            String passwd;
                            OMElement cassandraPasswd;
                            String user;
                            OMElement cassandraUser;
                            String url;
                            OMElement cassandraAuthConfig = this.loadCassandraAuthConfigXML();
                            OMElement serverEPR = cassandraAuthConfig.getFirstChildWithName(new QName("EPR"));
                            if (serverEPR != null && (url = serverEPR.getText()) != null && !"".equals(url.trim())) {
                                epr = url;
                            }
                            if ((cassandraUser = cassandraAuthConfig.getFirstChildWithName(new QName("User"))) != null && (user = cassandraUser.getText()) != null && !"".equals(user.trim())) {
                                username = user;
                            }
                            if ((cassandraPasswd = cassandraAuthConfig.getFirstChildWithName(new QName("Password"))) != null && (passwd = cassandraPasswd.getText()) != null && !"".equals(passwd.trim())) {
                                password = passwd;
                            }
                        }
                        String targetUser = (String)super.getHttpSession().getAttribute("wso2carbon.admin.logged.in");
                        String targetDomain = super.getTenantDomain();
                        if (targetDomain != null) {
                            targetUser = targetUser + "@" + targetDomain;
                        }
                        sharedKey = UUID.randomUUID().toString();
                        super.getHttpSession().setAttribute(USER_ACCESSKEY_ATTR_NAME, (Object)sharedKey);
                        OMElement payload = CassandraKeyspaceAdmin.getPayload(username, password, targetUser, sharedKey);
                        ServiceClient serviceClient = new ServiceClient(CassandraAdminDSComponent.getConfigCtxService().getClientConfigContext(), null);
                        Options options = new Options();
                        options.setAction("urn:injectAccessKey");
                        options.setProperty("TransportURL", (Object)epr);
                        serviceClient.setOptions(options);
                        serviceClient.sendRobust(payload);
                        serviceClient.cleanupTransport();
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (AxisFault e) {
                sharedKey = null;
                super.getHttpSession().removeAttribute(USER_ACCESSKEY_ATTR_NAME);
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        {
            return sharedKey;
        }
    }

    public static OMElement getPayload(String username, String password, String targetUser, String accessKey) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://sharedkey.cassandra.carbon.wso2.org", "m0");
        OMElement getKey = factory.createOMElement("giveMeAccessKey", ns);
        OMElement usernameElem = factory.createOMElement("username", ns);
        OMElement passwordElem = factory.createOMElement("password", ns);
        OMElement targetUserElem = factory.createOMElement("targetUser", ns);
        OMElement targetAccessKeyElem = factory.createOMElement("accessKey", ns);
        usernameElem.setText(username);
        passwordElem.setText(password);
        targetUserElem.setText(targetUser);
        targetAccessKeyElem.setText(accessKey);
        getKey.addChild((OMNode)usernameElem);
        getKey.addChild((OMNode)passwordElem);
        getKey.addChild((OMNode)targetUserElem);
        getKey.addChild((OMNode)targetAccessKeyElem);
        return getKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OMElement loadCassandraAuthConfigXML() {
        String carbonHome = System.getProperty("carbon.home");
        String path = carbonHome + File.separator + CASSANDRA_AUTH_CONF;
        BufferedInputStream inputStream = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                log.info((Object)("There is no " + CASSANDRA_AUTH_CONF + ". Using the default configuration"));
                inputStream = new BufferedInputStream(new ByteArrayInputStream("<Cassandra/>".getBytes()));
            } else {
                inputStream = new BufferedInputStream(new FileInputStream(file));
            }
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        catch (FileNotFoundException e) {
            log.error((Object)(CASSANDRA_AUTH_CONF + "cannot be found in the path : " + path), (Throwable)e);
        }
        catch (XMLStreamException e) {
            log.error((Object)("Invalid XML for " + CASSANDRA_AUTH_CONF + " located in " + "the path : " + path), (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ingored) {}
        }
        return null;
    }

    private boolean isAuthConfigurationExists() {
        String carbonHome = System.getProperty("carbon.home");
        String path = carbonHome + CASSANDRA_AUTH_CONF;
        if (!new File(path).exists()) {
            log.info((Object)("There is no " + CASSANDRA_AUTH_CONF + ". Using the default configuration"));
            return false;
        }
        return true;
    }

    private int getCarbonPortOffset() {
        ServerConfiguration carbonConfig = ServerConfiguration.getInstance();
        String portOffset = carbonConfig.getFirstProperty(CARBON_CONFIG_PORT_OFFSET);
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : CARBON_DEFAULT_PORT_OFFSET;
        }
        catch (NumberFormatException e) {
            return CARBON_DEFAULT_PORT_OFFSET;
        }
    }

    private String getServerURL() throws CassandraServerManagementException {
        ConfigurationContextService configurationContext = CassandraAdminComponentManager.getInstance().getConfigurationContextService();
        ServerConfigurationService serverConfigurationService = CassandraAdminComponentManager.getInstance().getServerConfigurationService();
        return CarbonUtils.getServerURL((ServerConfigurationService)serverConfigurationService, (ConfigurationContext)configurationContext.getServerConfigContext());
    }
}

