/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.mgt.ui;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.mgt.stub.ks.xsd.ColumnFamilyInformation;
import org.wso2.carbon.cassandra.mgt.stub.ks.xsd.ColumnInformation;
import org.wso2.carbon.cassandra.mgt.stub.ks.xsd.KeyspaceInformation;
import org.wso2.carbon.cassandra.mgt.ui.CassandraKeyspaceAdminClient;

public class CassandraAdminClientHelper {
    private static final Log log = LogFactory.getLog(CassandraAdminClientHelper.class);
    private static final String CASSANDRA_ENDPOINT_CONF = "repository" + File.separator + "conf" + File.separator + "etc" + File.separator + "cassandra-endpoint.xml";

    public static String getAliasForReplicationStrategyClass(String className) {
        if (className == null || "".equals(className)) {
            return "simple";
        }
        if ("org.apache.cassandra.locator.OldNetworkTopologyStrategy".equals(className = className.trim())) {
            return "oldnetwork";
        }
        if ("org.apache.cassandra.locator.NetworkTopologyStrategy".equals(className)) {
            return "network";
        }
        return "simple";
    }

    public static String getReplicationStrategyClassForAlias(String alias) {
        if (alias == null || "".equals(alias)) {
            return "org.apache.cassandra.locator.SimpleStrategy";
        }
        if ("oldnetwork".equals(alias = alias.trim())) {
            return "org.apache.cassandra.locator.OldNetworkTopologyStrategy";
        }
        if ("network".equals(alias)) {
            return "org.apache.cassandra.locator.NetworkTopologyStrategy";
        }
        return "org.apache.cassandra.locator.SimpleStrategy";
    }

    public static String getAliasForComparatorTypeClass(String className) {
        if (className == null || "".equals(className)) {
            return "org.apache.cassandra.db.marshal.BytesType";
        }
        if ("org.apache.cassandra.db.marshal.AsciiType".equals(className = className.trim())) {
            return "AsciiType";
        }
        if ("org.apache.cassandra.db.marshal.UTF8Type".equals(className)) {
            return "UTF8Type";
        }
        if ("org.apache.cassandra.db.marshal.LexicalUUIDType".equals(className)) {
            return "LexicalUUIDType";
        }
        if ("org.apache.cassandra.db.marshal.TimeUUIDType".equals(className)) {
            return "TimeUUIDType";
        }
        if ("org.apache.cassandra.db.marshal.LongType".equals(className)) {
            return "LongType";
        }
        if ("org.apache.cassandra.db.marshal.IntegerType".equals(className)) {
            return "IntegerType";
        }
        return "BytesType";
    }

    public static String getComparatorTypeClassForAlias(String alias) {
        if (alias == null || "".equals(alias)) {
            return "BytesType";
        }
        if ("AsciiType".equals(alias = alias.trim())) {
            return "org.apache.cassandra.db.marshal.AsciiType";
        }
        if ("UTF8Type".equals(alias)) {
            return "org.apache.cassandra.db.marshal.UTF8Type";
        }
        if ("LexicalUUIDType".equals(alias)) {
            return "org.apache.cassandra.db.marshal.LexicalUUIDType";
        }
        if ("TimeUUIDType".equals(alias)) {
            return "org.apache.cassandra.db.marshal.TimeUUIDType";
        }
        if ("LongType".equals(alias)) {
            return "org.apache.cassandra.db.marshal.LongType";
        }
        if ("IntegerType".equals(alias)) {
            return "org.apache.cassandra.db.marshal.IntegerType";
        }
        return "BytesType";
    }

    public static void fillDefaultValuesForCF(ColumnFamilyInformation information) {
        String validationClass;
        int rowCacheSavePeriod;
        int maxCompaction;
        int minCompaction;
        int gcGrace;
        double rawCacheSize;
        String comparatorType;
        String name = information.getName();
        if (name == null) {
            information.setName("");
        } else {
            information.setName(name.trim());
        }
        String type = information.getType();
        if (type == null || "".equals(type.trim())) {
            information.setType("Standard");
        }
        if ((comparatorType = information.getComparatorType()) == null || "".equals(comparatorType.trim())) {
            information.setComparatorType("org.apache.cassandra.db.marshal.BytesType");
        }
        if (!"Super".equalsIgnoreCase(type)) {
            information.setSubComparatorType("");
        } else {
            String subComparatorType = information.getSubComparatorType();
            if (subComparatorType == null || "".equals(subComparatorType.trim())) {
                information.setSubComparatorType("org.apache.cassandra.db.marshal.BytesType");
            }
        }
        String comment = information.getComment();
        if (comment == null) {
            information.setComment("");
        } else {
            information.setComment(comment.trim());
        }
        double keyCacheSize = information.getKeyCacheSize();
        if (keyCacheSize < 0.0) {
            information.setKeyCacheSize(0.0);
        }
        if ((rawCacheSize = information.getRowCacheSize()) < 0.0) {
            information.setRowCacheSize(0.0);
        }
        if ((gcGrace = information.getGcGraceSeconds()) <= 0) {
            information.setGcGraceSeconds(864000);
        }
        if ((minCompaction = information.getMinCompactionThreshold()) <= 0) {
            information.setMinCompactionThreshold(4);
        }
        if ((maxCompaction = information.getMaxCompactionThreshold()) <= 0) {
            information.setMaxCompactionThreshold(32);
        }
        if ((rowCacheSavePeriod = information.getRowCacheSavePeriodInSeconds()) <= 0) {
            information.setRowCacheSavePeriodInSeconds(7);
        }
        if ((validationClass = information.getDefaultValidationClass()) == null || "".equals(validationClass.trim())) {
            information.setDefaultValidationClass("org.apache.cassandra.db.marshal.BytesType");
        }
    }

    public static void fillDefaultValuesForCL(ColumnInformation information) {
        String indexName;
        String validationClass;
        String indexType = information.getIndexType();
        if (indexType == null) {
            information.setIndexType("keys");
        }
        if ((validationClass = information.getValidationClass()) == null || "".equals(validationClass.trim())) {
            information.setValidationClass("org.apache.cassandra.db.marshal.BytesType");
        }
        if ((indexName = information.getIndexName()) == null) {
            information.setIndexName("");
        }
    }

    public static ColumnFamilyInformation getColumnFamilyInformationOfCurrentUser(KeyspaceInformation keyspaceInformation, String cfName) {
        ColumnFamilyInformation[] columnFamilies = keyspaceInformation.getColumnFamilies();
        if (columnFamilies != null && columnFamilies.length > 0) {
            for (ColumnFamilyInformation cf : columnFamilies) {
                if (cf == null || !cfName.equals(cf.getName())) continue;
                return cf;
            }
        }
        return null;
    }

    public static void removeColumnFamilyInformation(KeyspaceInformation keyspaceInformation, String cfName) {
        ColumnFamilyInformation[] columnFamilies = keyspaceInformation.getColumnFamilies();
        ArrayList<ColumnFamilyInformation> newCFS = new ArrayList<ColumnFamilyInformation>();
        for (ColumnFamilyInformation cf : columnFamilies) {
            if (cf != null && cfName.equals(cf.getName())) continue;
            newCFS.add(cf);
        }
        keyspaceInformation.setColumnFamilies(newCFS.toArray(new ColumnFamilyInformation[newCFS.size()]));
    }

    public static void removeColumnInformation(ColumnFamilyInformation columnFamilyInformation, String clName) {
        ColumnInformation[] columns = columnFamilyInformation.getColumns();
        ArrayList<ColumnInformation> newCLS = new ArrayList<ColumnInformation>();
        for (ColumnInformation cl : columns) {
            if (cl != null && clName.equals(cl.getName())) continue;
            newCLS.add(cl);
        }
        columnFamilyInformation.setColumns(newCLS.toArray(new ColumnInformation[newCLS.size()]));
    }

    public static ColumnInformation getColumnInformation(ColumnFamilyInformation familyInformation, String clName) {
        ColumnInformation[] columnInformations = familyInformation.getColumns();
        if (columnInformations != null && columnInformations.length > 0) {
            for (ColumnInformation column : columnInformations) {
                if (column == null || !clName.equals(column.getName())) continue;
                return column;
            }
        }
        return null;
    }

    public static void addColumnInformation(ColumnFamilyInformation columnFamilyInformation, ColumnInformation newCL) {
        ColumnInformation[] columnInformations = columnFamilyInformation.getColumns();
        if (columnInformations != null && columnInformations.length > 0) {
            ArrayList<ColumnInformation> newCls = new ArrayList<ColumnInformation>();
            for (ColumnInformation cl : columnInformations) {
                newCls.add(cl);
            }
            newCls.add(newCL);
            columnFamilyInformation.setColumns(newCls.toArray(new ColumnInformation[newCls.size()]));
        } else {
            columnFamilyInformation.setColumns(new ColumnInformation[]{newCL});
        }
    }

    public static void addColumnFamilyInformation(KeyspaceInformation keyspaceInformation, ColumnFamilyInformation newCF) {
        ColumnFamilyInformation[] columnFamilies = keyspaceInformation.getColumnFamilies();
        if (columnFamilies != null && columnFamilies.length > 0) {
            ArrayList<ColumnFamilyInformation> newCfs = new ArrayList<ColumnFamilyInformation>();
            for (ColumnFamilyInformation cf : columnFamilies) {
                newCfs.add(cf);
            }
            newCfs.add(newCF);
            keyspaceInformation.setColumnFamilies(newCfs.toArray(new ColumnFamilyInformation[newCfs.size()]));
        } else {
            keyspaceInformation.setColumnFamilies(new ColumnFamilyInformation[]{newCF});
        }
    }

    public static KeyspaceInformation getKeyspaceInformation(ServletContext servletContext, HttpSession session, String keyspace) throws Exception {
        KeyspaceInformation keyspaceInformation = (KeyspaceInformation)session.getAttribute("CurrentKeyspace");
        if (keyspaceInformation == null) {
            CassandraKeyspaceAdminClient cassandraKeyspaceAdminClient = new CassandraKeyspaceAdminClient(servletContext, session);
            keyspaceInformation = cassandraKeyspaceAdminClient.getKeyspaceOfCurrentUser(keyspace);
            session.setAttribute("CurrentKeyspace", (Object)keyspaceInformation);
        }
        return keyspaceInformation;
    }

    public static String getClusterName(ServletContext servletContext, HttpSession session) throws Exception {
        CassandraKeyspaceAdminClient cassandraKeyspaceAdminClient = new CassandraKeyspaceAdminClient(servletContext, session);
        return cassandraKeyspaceAdminClient.getClusterName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMElement readCassandraEndpoints() {
        String carbonHome = System.getProperty("carbon.home");
        String path = carbonHome + File.separator + CASSANDRA_ENDPOINT_CONF;
        BufferedInputStream inputStream = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                log.info((Object)("There is no " + CASSANDRA_ENDPOINT_CONF + ". Using the default configuration"));
                inputStream = new BufferedInputStream(new ByteArrayInputStream("<Cassandra/>".getBytes()));
            } else {
                inputStream = new BufferedInputStream(new FileInputStream(file));
            }
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        catch (FileNotFoundException e) {
            log.error((Object)(CASSANDRA_ENDPOINT_CONF + "cannot be found in the path : " + path), (Throwable)e);
        }
        catch (XMLStreamException e) {
            log.error((Object)("Invalid XML for " + CASSANDRA_ENDPOINT_CONF + " located in " + "the path : " + path), (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ingored) {}
        }
        return null;
    }

    public static List<String> getCassandraEndPointList() {
        ArrayList<String> endPoints = new ArrayList<String>();
        OMElement cassandraEndPointConfig = CassandraAdminClientHelper.readCassandraEndpoints();
        Iterator omElementIterator = cassandraEndPointConfig.getChildrenWithName(new QName("EndPoints"));
        while (omElementIterator.hasNext()) {
            OMElement endPoint = (OMElement)omElementIterator.next();
            Iterator hostName = endPoint.getChildrenWithName(new QName("EndPoint"));
            while (hostName.hasNext()) {
                OMElement cssNode = (OMElement)hostName.next();
                OMElement cssNodeName = cssNode.getFirstChildWithName(new QName("HostName"));
                endPoints.add(cssNodeName.getText());
            }
        }
        return endPoints;
    }
}

