/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.mgt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.mgt.CassandraServerManagementException;
import org.wso2.carbon.cassandra.mgt.ColumnFamilyInformation;

public class KeyspaceInformation {
    private static final Log log = LogFactory.getLog(KeyspaceInformation.class);
    private String name;
    private String strategyClass = "org.apache.cassandra.locator.SimpleStrategy";
    private int replicationFactor = 1;
    private ColumnFamilyInformation[] columnFamilies;

    public KeyspaceInformation(String name) throws CassandraServerManagementException {
        if (name == null || "".equals(name.trim())) {
            throw new CassandraServerManagementException("The keyspace name is empty or null", log);
        }
        this.name = name.trim();
    }

    public KeyspaceInformation() {
    }

    public String getName() {
        return this.name;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        if (replicationFactor > 0) {
            this.replicationFactor = replicationFactor;
        }
    }

    public String getStrategyClass() {
        return this.strategyClass;
    }

    public void setStrategyClass(String strategyClass) {
        if (strategyClass != null && !"".equals(strategyClass.trim())) {
            this.strategyClass = strategyClass.trim();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public ColumnFamilyInformation[] getColumnFamilies() {
        return this.columnFamilies;
    }

    public void setColumnFamilies(ColumnFamilyInformation[] columnFamilies) {
        this.columnFamilies = columnFamilies;
    }
}

