/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import me.prettyprint.cassandra.model.HColumnImpl;
import me.prettyprint.cassandra.model.HSlicePredicate;
import me.prettyprint.cassandra.service.template.AbstractColumnFamilyTemplate;
import me.prettyprint.cassandra.service.template.SuperCfResult;
import me.prettyprint.cassandra.service.template.SuperCfRowMapper;
import me.prettyprint.cassandra.service.template.SuperCfUpdater;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.SubCountQuery;
import me.prettyprint.hector.api.query.SuperCountQuery;

public abstract class SuperCfTemplate<K, SN, N>
extends AbstractColumnFamilyTemplate<K, SN> {
    protected Serializer<N> subSerializer;

    public SuperCfTemplate(Keyspace keyspace, String columnFamily, Serializer<K> keySerializer, Serializer<SN> topSerializer, Serializer<N> subSerializer) {
        super(keyspace, columnFamily, keySerializer, topSerializer);
        this.subSerializer = subSerializer;
    }

    public Serializer<N> getSubSerializer() {
        return this.subSerializer;
    }

    public boolean isColumnsExist(K key) {
        return this.countColumns(key) > 0;
    }

    public boolean isSubColumnsExist(K key, SN superColumnName) {
        return this.countSubColumns(key, superColumnName) > 0;
    }

    public int countColumns(K key) {
        return this.countColumns(key, ALL_COLUMNS_START, ALL_COLUMNS_END, Integer.MAX_VALUE);
    }

    public int countSubColumns(K key, SN superColumnName) {
        return this.countSubColumns(key, superColumnName, ALL_COLUMNS_START, ALL_COLUMNS_END, Integer.MAX_VALUE);
    }

    public int countColumns(K key, SN start, SN end, int max) {
        SuperCountQuery<K, SN> query = HFactory.createSuperCountQuery(this.keyspace, this.keySerializer, this.topSerializer);
        query.setKey(key);
        query.setColumnFamily(this.columnFamily);
        query.setRange(start, end, max);
        return (Integer)query.execute().get();
    }

    public int countSubColumns(K key, SN superColumnName, N start, N end, int max) {
        SubCountQuery<K, SN, N> query = HFactory.createSubCountQuery(this.keyspace, this.keySerializer, this.topSerializer, this.subSerializer);
        query.setKey(key);
        query.setColumnFamily(this.columnFamily);
        query.setSuperColumn(superColumnName);
        query.setRange(start, end, max);
        return (Integer)query.execute().get();
    }

    public <V> HColumn<N, V> querySingleSubColumn(K key, SN columnName, N subColumnName, Serializer<V> valueSerializer) {
        SuperCfResult<K, SN, N> result = this.doExecuteSlice(key, columnName, this.activeSlicePredicate);
        if (result == null) {
            return null;
        }
        HColumn<N, ByteBuffer> origCol = result.getColumn(subColumnName);
        if (columnName == null || origCol == null) {
            return null;
        }
        return new HColumnImpl<N, V>(subColumnName, valueSerializer.fromByteBuffer(origCol.getValue()), origCol.getClock(), this.subSerializer, valueSerializer);
    }

    public SuperCfResult<K, SN, N> querySuperColumns(K key, HSlicePredicate<SN> predicate) {
        return this.doExecuteSlice(key, null, predicate);
    }

    public SuperCfResult<K, SN, N> querySuperColumns(K key, List<SN> sColumnNames) {
        HSlicePredicate<SN> workingSlicePredicate = new HSlicePredicate<SN>(this.topSerializer);
        workingSlicePredicate.setColumnNames((Collection<SN>)sColumnNames);
        return this.doExecuteSlice(key, null, workingSlicePredicate);
    }

    public SuperCfResult<K, SN, N> querySuperColumns(List<K> keys, List<SN> sColumnNames) {
        HSlicePredicate<SN> workingSlicePredicate = new HSlicePredicate<SN>(this.topSerializer);
        workingSlicePredicate.setColumnNames((Collection<SN>)sColumnNames);
        return this.doExecuteMultigetSlice(keys, workingSlicePredicate);
    }

    public SuperCfResult<K, SN, N> querySuperColumns(List<K> keys) {
        return this.doExecuteMultigetSlice(keys, this.activeSlicePredicate);
    }

    public <T> T querySuperColumns(K key, List<SN> sColumnNames, SuperCfRowMapper<K, SN, N, T> mapper) {
        HSlicePredicate<SN> workingSlicePredicate = new HSlicePredicate<SN>(this.topSerializer);
        workingSlicePredicate.setColumnNames((Collection<SN>)sColumnNames);
        return mapper.mapRow(this.doExecuteSlice(key, null, workingSlicePredicate));
    }

    public SuperCfResult<K, SN, N> querySuperColumns(K key) {
        return this.doExecuteSlice(key, null, this.activeSlicePredicate);
    }

    public SuperCfResult<K, SN, N> querySuperColumn(K key, SN sColumnName) {
        HSlicePredicate<SN> workingSlicePredicate = new HSlicePredicate<SN>(this.topSerializer);
        workingSlicePredicate.addColumnName(sColumnName);
        return this.doExecuteSlice(key, sColumnName, workingSlicePredicate);
    }

    public SuperCfUpdater<K, SN, N> createUpdater(K key, SN sColumnName) {
        return this.createUpdater(key).addSuperColumn(sColumnName);
    }

    public SuperCfUpdater<K, SN, N> createUpdater(K key) {
        SuperCfUpdater updater = new SuperCfUpdater(this, this.columnFactory);
        updater.addKey((Object)key);
        return updater;
    }

    public void update(SuperCfUpdater<K, SN, N> updater) {
        updater.updateInternal();
        updater.update();
        this.executeIfNotBatched(updater.getCurrentMutator());
    }

    @Override
    public void deleteColumn(K key, SN sColumnName) {
        this.createMutator().superDelete(key, this.getColumnFamily(), sColumnName, this.topSerializer);
    }

    @Override
    public void deleteRow(K key) {
        this.createMutator().delete(key, this.getColumnFamily(), null, null);
    }

    protected abstract SuperCfResult<K, SN, N> doExecuteSlice(K var1, SN var2, HSlicePredicate<SN> var3);

    protected abstract SuperCfResult<K, SN, N> doExecuteMultigetSlice(List<K> var1, HSlicePredicate<SN> var2);
}

