/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.Iterator;
import me.prettyprint.cassandra.model.IndexedSlicesQuery;
import me.prettyprint.hector.api.beans.Row;

public class IndexedSlicesIterator<K, N, V>
implements Iterator<Row<K, N, V>> {
    private IndexedSlicesQuery<K, N, V> query;
    private K startKey;
    private Iterator<Row<K, N, V>> iterator;
    private int rows = 0;

    public IndexedSlicesIterator(IndexedSlicesQuery<K, N, V> query, K startKey) {
        this.query = query;
        this.startKey = startKey;
        this.query.setStartKey(startKey);
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.query.execute().get().getList().iterator();
        } else if (!this.iterator.hasNext() && this.rows == this.query.getRowCount()) {
            this.query.setStartKey(this.startKey);
            this.iterator = this.query.execute().get().getList().iterator();
            this.rows = 0;
            if (this.iterator.hasNext()) {
                this.next();
            }
        }
        return this.iterator.hasNext();
    }

    @Override
    public Row<K, N, V> next() {
        Row<K, N, V> row = this.iterator.next();
        this.startKey = row.getKey();
        ++this.rows;
        return row;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

