/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import org.apache.cassandra.thrift.KeyRange;

public final class HKeyRange<K> {
    private K startKey;
    private K endKey;
    private int rowCount = 100;
    private final Serializer<K> keySerializer;

    public HKeyRange(Serializer<K> keySerializer) {
        Assert.notNull(keySerializer, "keySerializer is null");
        this.keySerializer = keySerializer;
    }

    public HKeyRange<K> setKeys(K start, K end) {
        this.startKey = start;
        this.endKey = end;
        return this;
    }

    public HKeyRange<K> setRowCount(int rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    public KeyRange toThrift() {
        KeyRange keyRange = new KeyRange(this.rowCount);
        keyRange.setStart_key(this.startKey == null ? ByteBuffer.wrap(new byte[0]) : this.keySerializer.toByteBuffer(this.startKey));
        keyRange.setEnd_key(this.endKey == null ? ByteBuffer.wrap(new byte[0]) : this.keySerializer.toByteBuffer(this.endKey));
        return keyRange;
    }

    public String toString() {
        return "HKeyRange(start:" + this.startKey + ",end:" + this.endKey + "," + ")";
    }
}

