/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.dataaccess;

import java.util.HashMap;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.dataaccess.ClusterConfiguration;
import org.wso2.carbon.cassandra.dataaccess.ClusterInformation;
import org.wso2.carbon.cassandra.dataaccess.DataAccessComponentException;
import org.wso2.carbon.cassandra.dataaccess.DataAccessComponentManager;
import org.wso2.carbon.cassandra.dataaccess.DataAccessService;
import org.wso2.carbon.cassandra.dataaccess.MultitenantClusterRepository;
import org.wso2.carbon.context.CarbonContext;

public class DataAccessServiceImpl
implements DataAccessService {
    private static Log log = LogFactory.getLog(DataAccessServiceImpl.class);
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static final String LOCAL_HOST_NAME = "localhost";
    private final DataAccessComponentManager dataAccessComponentManager = DataAccessComponentManager.getInstance();
    private final MultitenantClusterRepository clusterRepository = new MultitenantClusterRepository();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cluster getCluster(ClusterInformation clusterInformation) {
        String clusterName;
        if (clusterInformation == null) {
            throw new DataAccessComponentException("Provided Cluster information instance is null", log);
        }
        String username = clusterInformation.getUsername();
        Cluster cluster = this.clusterRepository.getCluster(username, clusterName = clusterInformation.getClusterName());
        if (cluster == null) {
            Object object = this.lock;
            synchronized (object) {
                cluster = this.clusterRepository.getCluster(username, clusterName);
                if (cluster != null) {
                    return cluster;
                }
                HashMap<String, String> credentials = new HashMap<String, String>();
                credentials.put(USERNAME_KEY, username);
                credentials.put(PASSWORD_KEY, clusterInformation.getPassword());
                CassandraHostConfigurator configurator = clusterInformation.getCassandraHostConfigurator();
                if (configurator == null) {
                    configurator = this.createCassandraHostConfigurator();
                }
                cluster = HFactory.createCluster((String)clusterName, (CassandraHostConfigurator)configurator, credentials);
                this.clusterRepository.putCluster(username, clusterName, cluster);
            }
        }
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cluster getCluster(ClusterInformation clusterInformation, boolean resetConnection) {
        String clusterName;
        if (clusterInformation == null) {
            throw new DataAccessComponentException("Provided Cluster information instance is null", log);
        }
        String username = clusterInformation.getUsername();
        Cluster cluster = this.clusterRepository.getCluster(username, clusterName = clusterInformation.getClusterName());
        if (cluster == null) {
            Object object = this.lock;
            synchronized (object) {
                cluster = this.clusterRepository.getCluster(username, clusterName);
                if (cluster != null) {
                    return cluster;
                }
                HashMap<String, String> credentials = new HashMap<String, String>();
                credentials.put(USERNAME_KEY, username);
                credentials.put(PASSWORD_KEY, clusterInformation.getPassword());
                CassandraHostConfigurator configurator = clusterInformation.getCassandraHostConfigurator();
                if (configurator == null) {
                    configurator = this.createCassandraHostConfigurator();
                }
                cluster = HFactory.createCluster((String)clusterName, (CassandraHostConfigurator)configurator, credentials);
                this.clusterRepository.putCluster(username, clusterName, cluster);
            }
        }
        return cluster;
    }

    @Override
    public Cluster getClusterForCurrentUser(String sharedKey) {
        CarbonContext carbonContext = CarbonContext.getCurrentContext();
        String userName = carbonContext.getUsername();
        String tenantDomain = carbonContext.getTenantDomain();
        if (tenantDomain != null && !"".equals(tenantDomain)) {
            userName = userName + "@" + tenantDomain;
        }
        ClusterConfiguration configuration = this.dataAccessComponentManager.getClusterConfiguration();
        ClusterInformation clusterInformation = new ClusterInformation(userName, sharedKey);
        clusterInformation.setClusterName(configuration.getClusterName());
        clusterInformation.setCassandraHostConfigurator(this.createCassandraHostConfigurator());
        return this.getCluster(clusterInformation);
    }

    @Override
    public Cluster getClusterForCurrentUser(String sharedKey, boolean resetConnection) {
        CarbonContext carbonContext = CarbonContext.getCurrentContext();
        String userName = carbonContext.getUsername();
        String tenantDomain = carbonContext.getTenantDomain();
        if (tenantDomain != null && !"".equals(tenantDomain)) {
            userName = userName + "@" + tenantDomain;
        }
        ClusterConfiguration configuration = this.dataAccessComponentManager.getClusterConfiguration();
        ClusterInformation clusterInformation = new ClusterInformation(userName, sharedKey);
        clusterInformation.setClusterName(configuration.getClusterName());
        clusterInformation.setCassandraHostConfigurator(this.createCassandraHostConfigurator());
        return this.getCluster(clusterInformation, resetConnection);
    }

    @Override
    public void destroyCluster(String name) {
        String userName = CarbonContext.getCurrentContext().getUsername();
        this.clusterRepository.removeCluster(userName, name);
    }

    @Override
    public void destroyClustersOfCurrentTenant() {
        this.clusterRepository.removeMyClusters();
    }

    @Override
    public void destroyClustersOfTenant(int tenantID) {
        this.clusterRepository.removeClusters(String.valueOf(tenantID));
    }

    @Override
    public void destroyAllClusters() {
        this.clusterRepository.removeAllClusters();
    }

    private CassandraHostConfigurator createCassandraHostConfigurator() {
        ClusterConfiguration configuration = this.dataAccessComponentManager.getClusterConfiguration();
        String carbonCassandraRPCPort = System.getProperty("cassandra.rpc_port");
        int cassandraDefaultPort = 0;
        String cassandraHosts = configuration.getNodesString();
        if (cassandraHosts == null || "".equals(cassandraHosts)) {
            cassandraHosts = "localhost:" + carbonCassandraRPCPort;
            cassandraDefaultPort = Integer.parseInt(carbonCassandraRPCPort);
        }
        CassandraHostConfigurator configurator = new CassandraHostConfigurator(cassandraHosts);
        configurator.setAutoDiscoverHosts(configuration.isAutoDiscovery());
        configurator.setAutoDiscoveryDelayInSeconds(configuration.getAutoDiscoveryDelay());
        if (cassandraDefaultPort > 0) {
            configurator.setPort(cassandraDefaultPort);
        } else {
            int configurationDefaultPort = configuration.getDefaultPort();
            configurator.setPort(configurationDefaultPort);
        }
        return configurator;
    }
}

