/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.dataaccess;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.dataaccess.ClusterConfiguration;
import org.wso2.carbon.cassandra.dataaccess.ClusterConfigurationFactory;
import org.wso2.carbon.cassandra.dataaccess.DataAccessComponentException;
import org.wso2.carbon.identity.authentication.SharedKeyAccessService;
import org.wso2.carbon.utils.CarbonUtils;

public class DataAccessComponentManager {
    private static Log log = LogFactory.getLog(DataAccessComponentManager.class);
    private static DataAccessComponentManager ourInstance = new DataAccessComponentManager();
    private ClusterConfiguration clusterConfiguration;
    private static final String CASSANDRA_COMPONENT_CONF = File.separator + "repository" + File.separator + "conf" + File.separator + "etc" + File.separator + "cassandra-component.xml";
    private SharedKeyAccessService sharedKeyAccessService;
    private boolean initialized = false;

    public static DataAccessComponentManager getInstance() {
        return ourInstance;
    }

    private DataAccessComponentManager() {
    }

    public void init(SharedKeyAccessService sharedKeyAccessService) {
        this.sharedKeyAccessService = sharedKeyAccessService;
        this.clusterConfiguration = ClusterConfigurationFactory.create(this.loadConfigXML());
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public ClusterConfiguration getClusterConfiguration() {
        this.assertInitialized();
        return this.clusterConfiguration;
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new DataAccessComponentException("Cassandra DataAccess component has not been initialized", log);
        }
    }

    public SharedKeyAccessService getSharedKeyAccessService() {
        this.assertInitialized();
        return this.sharedKeyAccessService;
    }

    private OMElement loadConfigXML() {
        String carbonHome = CarbonUtils.getCarbonHome();
        String path = carbonHome + CASSANDRA_COMPONENT_CONF;
        BufferedInputStream inputStream = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                log.info((Object)("There is no " + CASSANDRA_COMPONENT_CONF + ". Using the default configuration"));
                inputStream = new BufferedInputStream(new ByteArrayInputStream("<Cassandra/>".getBytes()));
            } else {
                inputStream = new BufferedInputStream(new FileInputStream(file));
            }
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        catch (FileNotFoundException e) {
            throw new DataAccessComponentException(CASSANDRA_COMPONENT_CONF + "cannot be found in the path : " + path, e, log);
        }
        catch (XMLStreamException e) {
            throw new DataAccessComponentException("Invalid XML for " + CASSANDRA_COMPONENT_CONF + " located in " + "the path : " + path, e, log);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ingored) {}
        }
    }
}

