/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.dataaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.dataaccess.DataAccessComponentException;

public class ClusterConfiguration {
    private static final Log log = LogFactory.getLog(ClusterConfiguration.class);
    private static final String DEFAULT_CLUSTER_NAME = "Test Cluster";
    private static final int DEFAULT_AUTO_DISCOVERY_INTERVAL = 30;
    private static final String DEPLOYMENT_EMBEDDED = "embedded";
    private static final String DEPLOYMENT_EXTERNAL = "external";
    private String authenticationServer = "Test Cluster";
    private final Map<String, String> userNodes = new HashMap<String, String>();
    private final List<String> nodes = new ArrayList<String>();
    private String nodesString;
    private String clusterName = "Test Cluster";
    private boolean autoDiscovery = true;
    private int autoDiscoveryDelay = 30;
    private String deploymentMode = "embedded";
    private int defaultPort = 9160;

    public String getAuthenticationServer() {
        return this.authenticationServer;
    }

    public void setAuthenticationServer(String authenticationServer) {
        this.authenticationServer = authenticationServer;
    }

    public void addNode(String nodeURL) {
        this.validateNodeLocation(nodeURL);
        this.nodes.add(nodeURL);
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public void addNodeLocation(String username, String nodeLocation) {
        this.validateUsername(username);
        this.validateNodeLocation(nodeLocation);
        this.userNodes.put(username.trim(), nodeLocation.trim());
    }

    public String getNodeLocation(String username) {
        this.validateUsername(username);
        return this.userNodes.get(username.trim());
    }

    private void validateUsername(String username) throws DataAccessComponentException {
        if (username == null || "".equals(username.trim())) {
            throw new DataAccessComponentException("Username is null or empty", log);
        }
    }

    private void validateNodeLocation(String nodeLocation) throws DataAccessComponentException {
        if (nodeLocation == null || "".equals(nodeLocation.trim())) {
            throw new DataAccessComponentException("Node location is null or empty", log);
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getNodesString() {
        return this.nodesString;
    }

    public void setNodesString(String nodesString) {
        this.nodesString = nodesString;
    }

    public boolean isAutoDiscovery() {
        return this.autoDiscovery;
    }

    public void setAutoDiscovery(boolean autoDiscovery) {
        this.autoDiscovery = autoDiscovery;
    }

    public int getAutoDiscoveryDelay() {
        return this.autoDiscoveryDelay;
    }

    public void setAutoDiscoveryDelay(int autoDiscoveryDelay) {
        this.autoDiscoveryDelay = autoDiscoveryDelay;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public boolean isDeploymentModeEmbedded() {
        return DEPLOYMENT_EMBEDDED.equals(this.deploymentMode);
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }
}

