/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.columniterator.ICountableColumnIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.LazilyCompactedRow;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.PrecompactedRow;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.HeapAllocator;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelCompactionIterable
extends AbstractCompactionIterable {
    private static Logger logger = LoggerFactory.getLogger(ParallelCompactionIterable.class);
    private final int maxInMemorySize;

    public ParallelCompactionIterable(OperationType type, Iterable<SSTableReader> sstables, CompactionController controller) throws IOException {
        this(type, ParallelCompactionIterable.getScanners(sstables), controller, DatabaseDescriptor.getInMemoryCompactionLimit() / Iterables.size(sstables));
    }

    public ParallelCompactionIterable(OperationType type, Iterable<SSTableReader> sstables, CompactionController controller, int maxInMemorySize) throws IOException {
        this(type, ParallelCompactionIterable.getScanners(sstables), controller, maxInMemorySize);
    }

    protected ParallelCompactionIterable(OperationType type, List<SSTableScanner> scanners, CompactionController controller, int maxInMemorySize) {
        super(controller, type, scanners);
        this.maxInMemorySize = maxInMemorySize;
    }

    @Override
    public CloseableIterator<AbstractCompactedRow> iterator() {
        ArrayList<Deserializer> sources = new ArrayList<Deserializer>();
        for (SSTableScanner scanner : this.scanners) {
            sources.add(new Deserializer(scanner, this.maxInMemorySize));
        }
        return new Unwrapper(MergeIterator.get(sources, RowContainer.comparator, new Reducer()), this.controller);
    }

    private static class CompactedRowContainer {
        public final DecoratedKey key;
        public final Future<ColumnFamily> future;
        public final LazilyCompactedRow row;

        private CompactedRowContainer(DecoratedKey key, Future<ColumnFamily> future) {
            this.key = key;
            this.future = future;
            this.row = null;
        }

        private CompactedRowContainer(LazilyCompactedRow row) {
            this.row = row;
            this.future = null;
            this.key = null;
        }
    }

    private static class RowContainer {
        public final Row row;
        public final NotifyingSSTableIdentityIterator wrapper;
        public static final Comparator<RowContainer> comparator = new Comparator<RowContainer>(){

            @Override
            public int compare(RowContainer o1, RowContainer o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        };

        private RowContainer(Row row) {
            this.row = row;
            this.wrapper = null;
        }

        public RowContainer(NotifyingSSTableIdentityIterator wrapper) {
            this.wrapper = wrapper;
            this.row = null;
        }

        public DecoratedKey getKey() {
            return this.row == null ? this.wrapper.getKey() : this.row.key;
        }
    }

    private static class NotifyingSSTableIdentityIterator
    implements ICountableColumnIterator {
        private final SSTableIdentityIterator wrapped;
        private final Condition condition;

        public NotifyingSSTableIdentityIterator(SSTableIdentityIterator wrapped, Condition condition) {
            this.wrapped = wrapped;
            this.condition = condition;
        }

        @Override
        public ColumnFamily getColumnFamily() {
            return this.wrapped.getColumnFamily();
        }

        @Override
        public DecoratedKey getKey() {
            return this.wrapped.getKey();
        }

        @Override
        public int getColumnCount() {
            return this.wrapped.getColumnCount();
        }

        @Override
        public void reset() {
            this.wrapped.reset();
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
            this.condition.signal();
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public IColumn next() {
            return this.wrapped.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Deserializer
    extends AbstractIterator<RowContainer>
    implements CloseableIterator<RowContainer> {
        private final LinkedBlockingQueue<RowContainer> queue = new LinkedBlockingQueue(1);
        private static final RowContainer finished = new RowContainer(null);
        private Condition condition;
        private final SSTableScanner scanner;

        public Deserializer(SSTableScanner ssts, final int maxInMemorySize) {
            this.scanner = ssts;
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws Exception {
                    while (true) {
                        if (Deserializer.this.condition != null) {
                            Deserializer.this.condition.await();
                        }
                        if (!Deserializer.this.scanner.hasNext()) break;
                        SSTableIdentityIterator iter = (SSTableIdentityIterator)Deserializer.this.scanner.next();
                        if (iter.dataSize > (long)maxInMemorySize) {
                            logger.debug("parallel lazy deserialize from " + iter.getPath());
                            Deserializer.this.condition = new SimpleCondition();
                            Deserializer.this.queue.put(new RowContainer(new NotifyingSSTableIdentityIterator(iter, Deserializer.this.condition)));
                            continue;
                        }
                        logger.debug("parallel eager deserialize from " + iter.getPath());
                        Deserializer.this.queue.put(new RowContainer(new Row(iter.getKey(), iter.getColumnFamilyWithColumns())));
                    }
                    Deserializer.this.queue.put(finished);
                }
            };
            new Thread((Runnable)runnable, "Deserialize " + this.scanner.sstable).start();
        }

        protected RowContainer computeNext() {
            RowContainer container;
            try {
                container = this.queue.take();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            return container == finished ? (RowContainer)this.endOfData() : container;
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
        }
    }

    private class Reducer
    extends MergeIterator.Reducer<RowContainer, CompactedRowContainer> {
        private final List<RowContainer> rows = new ArrayList<RowContainer>();
        private int row = 0;
        private final ThreadPoolExecutor executor = new DebuggableThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("CompactionReducer"));

        private Reducer() {
        }

        @Override
        public void reduce(RowContainer current) {
            this.rows.add(current);
        }

        @Override
        protected CompactedRowContainer getReduced() {
            assert (this.rows.size() > 0);
            CompactedRowContainer compacted = this.getCompactedRow(this.rows);
            this.rows.clear();
            if (this.row++ % 1000 == 0) {
                long n = 0L;
                for (SSTableScanner scanner : ParallelCompactionIterable.this.scanners) {
                    n += scanner.getFilePointer();
                }
                ParallelCompactionIterable.this.bytesRead = n;
                ParallelCompactionIterable.this.throttle.throttle(ParallelCompactionIterable.this.bytesRead);
            }
            return compacted;
        }

        public CompactedRowContainer getCompactedRow(List<RowContainer> rows) {
            boolean inMemory = true;
            for (RowContainer container : rows) {
                if (container.row != null) continue;
                inMemory = false;
                break;
            }
            if (inMemory) {
                return new CompactedRowContainer(rows.get(0).getKey(), this.executor.submit(new MergeTask(new ArrayList<RowContainer>(rows))));
            }
            ArrayList<NotifyingSSTableIdentityIterator> iterators = new ArrayList<NotifyingSSTableIdentityIterator>();
            for (RowContainer container : rows) {
                iterators.add((NotifyingSSTableIdentityIterator)(container.row == null ? container.wrapper : new DeserializedColumnIterator(container.row)));
            }
            return new CompactedRowContainer(new LazilyCompactedRow(ParallelCompactionIterable.this.controller, iterators));
        }

        @Override
        public void close() {
            this.executor.shutdown();
        }

        private class DeserializedColumnIterator
        implements ICountableColumnIterator {
            private final Row row;
            private Iterator<IColumn> iter;

            public DeserializedColumnIterator(Row row) {
                this.row = row;
                this.iter = row.cf.iterator();
            }

            @Override
            public ColumnFamily getColumnFamily() {
                return this.row.cf;
            }

            @Override
            public DecoratedKey getKey() {
                return this.row.key;
            }

            @Override
            public int getColumnCount() {
                return this.row.cf.getColumnCount();
            }

            @Override
            public void reset() {
                this.iter = this.row.cf.iterator();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public IColumn next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private class MergeTask
        implements Callable<ColumnFamily> {
            private final List<RowContainer> rows;

            public MergeTask(List<RowContainer> rows) {
                this.rows = rows;
            }

            @Override
            public ColumnFamily call() throws Exception {
                ColumnFamily cf = null;
                for (RowContainer container : this.rows) {
                    ColumnFamily thisCF = container.row.cf;
                    if (cf == null) {
                        cf = thisCF;
                        continue;
                    }
                    cf.addAll(thisCF, HeapAllocator.instance);
                }
                return PrecompactedRow.removeDeletedAndOldShards(this.rows.get(0).getKey(), ParallelCompactionIterable.this.controller, cf);
            }
        }
    }

    private static class Unwrapper
    extends AbstractIterator<AbstractCompactedRow>
    implements CloseableIterator<AbstractCompactedRow> {
        private final CloseableIterator<CompactedRowContainer> reducer;
        private final CompactionController controller;

        public Unwrapper(CloseableIterator<CompactedRowContainer> reducer, CompactionController controller) {
            this.reducer = reducer;
            this.controller = controller;
        }

        protected AbstractCompactedRow computeNext() {
            AbstractCompactedRow compactedRow;
            if (!this.reducer.hasNext()) {
                return (AbstractCompactedRow)this.endOfData();
            }
            CompactedRowContainer container = (CompactedRowContainer)this.reducer.next();
            try {
                compactedRow = container.future == null ? container.row : new PrecompactedRow(container.key, container.future.get());
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            if (compactedRow.isEmpty()) {
                this.controller.invalidateCachedRow(compactedRow.key);
                return null;
            }
            this.controller.invalidateCachedRow(compactedRow.key);
            return compactedRow;
        }

        @Override
        public void close() throws IOException {
            this.reducer.close();
        }
    }
}

