/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.auth.Action;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.RequestType;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;

public abstract class ModificationStatement
extends CFStatement
implements CQLStatement {
    public static final ConsistencyLevel defaultConsistency = ConsistencyLevel.ONE;
    protected final ConsistencyLevel cLevel;
    protected Long timestamp;
    protected final int timeToLive;

    public ModificationStatement(CFName name, Attributes attrs) {
        this(name, attrs.cLevel, attrs.timestamp, attrs.timeToLive);
    }

    public ModificationStatement(CFName name, ConsistencyLevel cLevel, Long timestamp, int timeToLive) {
        super(name);
        this.cLevel = cLevel;
        this.timestamp = timestamp;
        this.timeToLive = timeToLive;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.WRITE, Action.UPDATE);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.timeToLive < 0) {
            throw new InvalidRequestException("A TTL must be greater or equal to 0");
        }
        ThriftValidation.validateConsistencyLevel(this.keyspace(), this.getConsistencyLevel(), RequestType.WRITE);
    }

    @Override
    public CqlResult execute(ClientState state, List<ByteBuffer> variables) throws InvalidRequestException, UnavailableException, TimedOutException {
        try {
            StorageProxy.mutate(this.getMutations(state, variables), this.getConsistencyLevel());
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        return null;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.cLevel != null ? this.cLevel : defaultConsistency;
    }

    public boolean isSetConsistencyLevel() {
        return this.cLevel != null;
    }

    public long getTimestamp(ClientState clientState) {
        return this.timestamp == null ? clientState.getTimestamp() : this.timestamp.longValue();
    }

    public boolean isSetTimestamp() {
        return this.timestamp != null;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public abstract List<IMutation> getMutations(ClientState var1, List<ByteBuffer> var2) throws InvalidRequestException;
}

