/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.server;

import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.core.CacheEntry;
import org.wso2.carbon.caching.core.CacheKey;
import org.wso2.carbon.caching.core.StringCacheEntry;
import org.wso2.carbon.caching.core.StringCacheKey;
import org.wso2.carbon.cassandra.server.CassandraServerComponentManager;
import org.wso2.carbon.cassandra.server.cache.UserAccessKeyCache;
import org.wso2.carbon.identity.authentication.AuthenticationService;

public class CarbonCassandraAuthenticator
implements IAuthenticator {
    private static final Log log = LogFactory.getLog(CarbonCassandraAuthenticator.class);
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    private AuthenticationService authenticationService;
    private static final UserAccessKeyCache cache = UserAccessKeyCache.getInstance();

    public AuthenticatedUser defaultUser() {
        return null;
    }

    public static void addToCache(String username, String accessKey) {
        cache.addToCache((CacheKey)new StringCacheKey(username), (CacheEntry)new StringCacheEntry(accessKey));
    }

    public AuthenticatedUser authenticate(Map<? extends CharSequence, ? extends CharSequence> credentials) throws AuthenticationException {
        CharSequence pass;
        String domainName = "carbon.super";
        CharSequence user = credentials.get(USERNAME_KEY);
        if (null == user) {
            this.logAndAuthenticationException("Authentication request was missing the required key 'username'");
        }
        assert (user != null);
        String userName = ((Object)user).toString();
        if (userName.indexOf("@") > 0 && ((domainName = userName.substring(userName.indexOf("@") + 1)) == null || domainName.trim().equals(""))) {
            this.logAndAuthenticationException("Authentication request was missing the domain name of the user in the key username");
        }
        if (null == (pass = credentials.get(PASSWORD_KEY))) {
            this.logAndAuthenticationException("Authentication request was missing the required key 'password'");
        }
        assert (pass != null);
        String password = ((Object)pass).toString();
        if (this.isAuthenticated(userName, password)) {
            AuthenticatedUser authenticatedUser = new AuthenticatedUser(userName, Collections.emptySet(), domainName);
            return authenticatedUser;
        }
        if (this.authenticationService.authenticate(userName, password)) {
            CarbonCassandraAuthenticator.addToCache(userName, password);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Credentials for Username : " + userName + " added to cache"));
            }
            AuthenticatedUser authenticatedUser = new AuthenticatedUser(userName, Collections.emptySet(), domainName);
            return authenticatedUser;
        }
        return null;
    }

    private boolean isAuthenticated(String username, String keyAccess) {
        CacheEntry cacheEntry = cache.getValueFromCache((CacheKey)new StringCacheKey(username));
        String value = null;
        if (cacheEntry != null) {
            value = ((StringCacheEntry)cacheEntry).getStringValue();
        } else {
            log.error((Object)"The key is not present in the cache...");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Credentials for Username : " + username + " retrieved from cache"));
            }
        }
        return keyAccess != null && keyAccess.equals(value);
    }

    public void validateConfiguration() throws ConfigurationException {
        CassandraServerComponentManager manager = CassandraServerComponentManager.getInstance();
        this.authenticationService = manager.getAuthenticationService();
    }

    private void logAndAuthenticationException(String msg) throws AuthenticationException {
        log.error((Object)msg);
        throw new AuthenticationException(msg);
    }
}

