/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.hector.api.ResultStatus;

public class ExecutionResult<T>
implements ResultStatus {
    private final T value;
    private final long execTime;
    private final CassandraHost cassandraHost;
    protected static final String BASE_MSG_FORMAT = "%s took (%dus) for query (%s) on host: %s";
    private static final int MICRO_DENOM = 1000;

    public ExecutionResult(T value, long execTime, CassandraHost cassandraHost) {
        this.value = value;
        this.execTime = execTime;
        this.cassandraHost = cassandraHost;
    }

    public T get() {
        return this.value;
    }

    @Override
    public long getExecutionTimeNano() {
        return this.execTime;
    }

    @Override
    public long getExecutionTimeMicro() {
        return this.execTime / 1000L;
    }

    public String toString() {
        return this.formatMessage("ExecutionResult", "n/a");
    }

    protected String formatMessage(String resultName, String query) {
        return String.format(BASE_MSG_FORMAT, resultName, this.getExecutionTimeMicro(), query, this.cassandraHost != null ? this.cassandraHost.getName() : "[none]");
    }

    @Override
    public CassandraHost getHostUsed() {
        return this.cassandraHost;
    }
}

