/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.dataaccess.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.cassandra.dataaccess.CassandraAxis2ConfigurationContextObserver;
import org.wso2.carbon.cassandra.dataaccess.DataAccessComponentManager;
import org.wso2.carbon.cassandra.dataaccess.DataAccessService;
import org.wso2.carbon.cassandra.dataaccess.DataAccessServiceImpl;
import org.wso2.carbon.identity.authentication.SharedKeyAccessService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

public class DataAccessServiceDSComponent {
    private static Log log = LogFactory.getLog(DataAccessServiceDSComponent.class);
    private ServiceRegistration serviceRegistration;
    private SharedKeyAccessService sharedKeyAccessService;
    private DataAccessService dataAccessService;
    private ServiceRegistration axisConfigContextObserverServiceReg;

    protected void activate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting the data access component for Cassandra");
        }
        DataAccessComponentManager.getInstance().init(this.sharedKeyAccessService);
        this.dataAccessService = new DataAccessServiceImpl();
        this.serviceRegistration = componentContext.getBundleContext().registerService(DataAccessService.class.getName(), (Object)this.dataAccessService, null);
        this.axisConfigContextObserverServiceReg = componentContext.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new CassandraAxis2ConfigurationContextObserver(this.dataAccessService), null);
    }

    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping the data access component for Cassandra");
        }
        this.dataAccessService.destroyAllClusters();
        componentContext.getBundleContext().ungetService(this.serviceRegistration.getReference());
        componentContext.getBundleContext().ungetService(this.axisConfigContextObserverServiceReg.getReference());
    }

    protected void setSharedKeyAccessService(SharedKeyAccessService sharedKeyAccessService) {
        this.sharedKeyAccessService = sharedKeyAccessService;
    }

    protected void unsetSharedKeyAccessService(SharedKeyAccessService sharedKeyAccessService) {
        this.sharedKeyAccessService = null;
    }
}

