/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.dataaccess;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cassandra.dataaccess.ClusterConfiguration;
import org.wso2.carbon.cassandra.dataaccess.DataAccessComponentException;

public class ClusterConfigurationFactory {
    private static Log log = LogFactory.getLog(ClusterConfigurationFactory.class);

    public static ClusterConfiguration create(OMElement severElement) {
        OMElement cluster;
        String mode;
        ClusterConfiguration clusterConfiguration = new ClusterConfiguration();
        OMElement deployment = severElement.getFirstChildWithName(new QName("Deployment"));
        if (deployment != null && (mode = deployment.getText()) != null && !"".equals(mode.trim())) {
            clusterConfiguration.setDeploymentMode(mode.trim());
        }
        if ((cluster = severElement.getFirstChildWithName(new QName("Cluster"))) != null) {
            OMElement autoDiscoveryElement;
            String nodesString;
            OMElement nodesElement;
            String port;
            OMElement portElement;
            OMElement nameElement = cluster.getFirstChildWithName(new QName("Name"));
            if (nameElement != null) {
                String name = nameElement.getText();
                if (name == null || "".equals(name.trim())) {
                    throw new DataAccessComponentException("Name is null or empty", log);
                }
                clusterConfiguration.setClusterName(name.trim());
            }
            if ((portElement = cluster.getFirstChildWithName(new QName("DefaultPort"))) != null && (port = portElement.getText()) != null && !"".equals(port.trim())) {
                try {
                    clusterConfiguration.setDefaultPort(Integer.parseInt(port.trim()));
                }
                catch (NumberFormatException e) {
                    throw new DataAccessComponentException("An invalid number for defaultport : " + port, log);
                }
            }
            if ((nodesElement = cluster.getFirstChildWithName(new QName("Nodes"))) != null && (nodesString = nodesElement.getText()) != null && !"".endsWith(nodesString.trim())) {
                String[] nodes;
                clusterConfiguration.setNodesString(nodesString.trim());
                for (String node : nodes = nodesString.split(",")) {
                    clusterConfiguration.addNode(node);
                }
            }
            if ((autoDiscoveryElement = cluster.getFirstChildWithName(new QName("AutoDiscovery"))) != null) {
                String delay;
                String disable = autoDiscoveryElement.getAttributeValue(new QName("disable"));
                if (disable != null && !"".equals(disable.trim())) {
                    clusterConfiguration.setAutoDiscovery(!Boolean.parseBoolean(disable.trim()));
                }
                if ((delay = autoDiscoveryElement.getAttributeValue(new QName("delay"))) != null && !"".equals(delay.trim())) {
                    int delayAsInt = -1;
                    try {
                        delayAsInt = Integer.parseInt(delay.trim());
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                    if (delayAsInt > 0) {
                        clusterConfiguration.setAutoDiscoveryDelay(delayAsInt);
                    }
                }
            }
        }
        return clusterConfiguration;
    }
}

