/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.SSTable;

public class IndexSummary {
    private ArrayList<Long> positions;
    private ArrayList<DecoratedKey<?>> keys;
    private long keysWritten = 0L;

    public IndexSummary(long expectedKeys) {
        long expectedEntries = expectedKeys / (long)DatabaseDescriptor.getIndexInterval().intValue();
        if (expectedEntries > Integer.MAX_VALUE) {
            throw new RuntimeException("Cannot use index_interval of " + DatabaseDescriptor.getIndexInterval() + " with " + expectedKeys + " (expected) keys.");
        }
        this.positions = new ArrayList((int)expectedEntries);
        this.keys = new ArrayList((int)expectedEntries);
    }

    public void incrementRowid() {
        ++this.keysWritten;
    }

    public boolean shouldAddEntry() {
        return this.keysWritten % (long)DatabaseDescriptor.getIndexInterval().intValue() == 0L;
    }

    public void addEntry(DecoratedKey<?> key, long indexPosition) {
        this.keys.add(SSTable.getMinimalKey(key));
        this.positions.add(indexPosition);
    }

    public void maybeAddEntry(DecoratedKey<?> decoratedKey, long indexPosition) {
        if (this.shouldAddEntry()) {
            this.addEntry(decoratedKey, indexPosition);
        }
        this.incrementRowid();
    }

    public List<DecoratedKey<?>> getKeys() {
        return this.keys;
    }

    public long getPosition(int index) {
        return this.positions.get(index);
    }

    public void complete() {
        this.keys.trimToSize();
        this.positions.trimToSize();
    }
}

