/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilyInputFormat
extends InputFormat<ByteBuffer, SortedMap<ByteBuffer, IColumn>>
implements org.apache.hadoop.mapred.InputFormat<ByteBuffer, SortedMap<ByteBuffer, IColumn>> {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilyInputFormat.class);
    public static final String MAPRED_TASK_ID = "mapred.task.id";
    public static final String CASSANDRA_HADOOP_MAX_KEY_SIZE = "cassandra.hadoop.max_key_size";
    public static final int CASSANDRA_HADOOP_MAX_KEY_SIZE_DEFAULT = 8192;
    private String keyspace;
    private String cfName;
    private IPartitioner partitioner;

    private static void validateConfiguration(Configuration conf) {
        if (ConfigHelper.getInputKeyspace(conf) == null || ConfigHelper.getInputColumnFamily(conf) == null) {
            throw new UnsupportedOperationException("you must set the keyspace and columnfamily with setColumnFamily()");
        }
        if (ConfigHelper.getInputSlicePredicate(conf) == null) {
            throw new UnsupportedOperationException("you must set the predicate with setPredicate");
        }
        if (ConfigHelper.getInputInitialAddress(conf) == null) {
            throw new UnsupportedOperationException("You must set the initial output address to a Cassandra node");
        }
        if (ConfigHelper.getInputPartitioner(conf) == null) {
            throw new UnsupportedOperationException("You must set the Cassandra partitioner class");
        }
    }

    /*
     * Exception decompiling
     */
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getSubSplits(String keyspace, String cfName, TokenRange range, Configuration conf) throws IOException {
        int splitsize = ConfigHelper.getInputSplitSize(conf);
        for (int i = 0; i < range.rpc_endpoints.size(); ++i) {
            String host = range.rpc_endpoints.get(i);
            if (host == null || host.equals("0.0.0.0")) {
                host = range.endpoints.get(i);
            }
            try {
                Cassandra.Client client = ConfigHelper.createConnection(host, ConfigHelper.getInputRpcPort(conf), true);
                client.set_keyspace(keyspace);
                return client.describe_splits(cfName, range.start_token, range.end_token, splitsize);
            }
            catch (IOException e) {
                logger.debug("failed connect to endpoint " + host, (Throwable)e);
                continue;
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidRequestException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IOException("failed connecting to all endpoints " + StringUtils.join(range.endpoints, (String)","));
    }

    private List<TokenRange> getRangeMap(Configuration conf) throws IOException {
        List<TokenRange> map;
        Cassandra.Client client = ConfigHelper.getClientFromInputAddressList(conf);
        try {
            map = client.describe_ring(ConfigHelper.getInputKeyspace(conf));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public RecordReader<ByteBuffer, SortedMap<ByteBuffer, IColumn>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new ColumnFamilyRecordReader();
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        TaskAttemptContext tac = new TaskAttemptContext((Configuration)jobConf, new TaskAttemptID());
        List<InputSplit> newInputSplits = this.getSplits((JobContext)tac);
        org.apache.hadoop.mapred.InputSplit[] oldInputSplits = new org.apache.hadoop.mapred.InputSplit[newInputSplits.size()];
        for (int i = 0; i < newInputSplits.size(); ++i) {
            oldInputSplits[i] = (ColumnFamilySplit)newInputSplits.get(i);
        }
        return oldInputSplits;
    }

    public org.apache.hadoop.mapred.RecordReader<ByteBuffer, SortedMap<ByteBuffer, IColumn>> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf jobConf, final Reporter reporter) throws IOException {
        TaskAttemptContext tac = new TaskAttemptContext((Configuration)jobConf, TaskAttemptID.forName((String)jobConf.get(MAPRED_TASK_ID))){

            public void progress() {
                reporter.progress();
            }
        };
        ColumnFamilyRecordReader recordReader = new ColumnFamilyRecordReader(jobConf.getInt(CASSANDRA_HADOOP_MAX_KEY_SIZE, 8192));
        recordReader.initialize((InputSplit)split, tac);
        return recordReader;
    }

    class SplitCallable
    implements Callable<List<InputSplit>> {
        private final TokenRange range;
        private final Configuration conf;

        public SplitCallable(TokenRange tr, Configuration conf) {
            this.range = tr;
            this.conf = conf;
        }

        @Override
        public List<InputSplit> call() throws Exception {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            List tokens = ColumnFamilyInputFormat.this.getSubSplits(ColumnFamilyInputFormat.this.keyspace, ColumnFamilyInputFormat.this.cfName, this.range, this.conf);
            assert (this.range.rpc_endpoints.size() == this.range.endpoints.size()) : "rpc_endpoints size must match endpoints size";
            String[] endpoints = this.range.endpoints.toArray(new String[this.range.endpoints.size()]);
            int endpointIndex = 0;
            for (String endpoint : this.range.rpc_endpoints) {
                String endpoint_address = endpoint;
                if (endpoint_address == null || endpoint_address.equals("0.0.0.0")) {
                    endpoint_address = this.range.endpoints.get(endpointIndex);
                }
                endpoints[endpointIndex++] = InetAddress.getByName(endpoint_address).getHostName();
            }
            Token.TokenFactory factory = ColumnFamilyInputFormat.this.partitioner.getTokenFactory();
            for (int i = 1; i < tokens.size(); ++i) {
                Token right;
                Token left = factory.fromString((String)tokens.get(i - 1));
                Range range = new Range(left, right = factory.fromString((String)tokens.get(i)), ColumnFamilyInputFormat.this.partitioner);
                ImmutableList ranges = range.isWrapAround() ? range.unwrap() : ImmutableList.of(range);
                for (Range subrange : ranges) {
                    ColumnFamilySplit split = new ColumnFamilySplit(factory.toString((Token)subrange.left), factory.toString((Token)subrange.right), endpoints);
                    logger.debug("adding " + (Object)((Object)split));
                    splits.add(split);
                }
            }
            return splits;
        }
    }
}

