/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.explorer.ui;

import java.rmi.RemoteException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.cassandra.explorer.stub.CassandraExplorerAdminCassandraExplorerException;
import org.wso2.carbon.cassandra.explorer.stub.CassandraExplorerAdminStub;
import org.wso2.carbon.cassandra.explorer.stub.data.xsd.Column;
import org.wso2.carbon.cassandra.explorer.stub.data.xsd.Row;
import org.wso2.carbon.ui.CarbonUIUtil;

public class CassandraExplorerAdminClient {
    CassandraExplorerAdminStub explorerAdminStub;

    public CassandraExplorerAdminClient(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        this.init(ctx, serverURL, cookie);
    }

    public CassandraExplorerAdminClient(ServletContext servletContext, HttpSession httpSession) throws Exception {
        ConfigurationContext ctx = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String cookie = (String)httpSession.getAttribute("wso2carbon.admin.service.cookie");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)httpSession);
        this.init(ctx, serverURL, cookie);
    }

    private void init(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        String serviceURL = serverURL + "CassandraExplorerAdmin";
        this.explorerAdminStub = new CassandraExplorerAdminStub(ctx, serviceURL);
        ServiceClient client = this.explorerAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        options.setTimeOutInMilliSeconds(10000L);
        options.setProperty("CHARACTER_SET_ENCODING", (Object)"UTF-16");
    }

    public Column[] getPaginateSliceforColumns(String keyspace, String columnFamily, String rowName, int startingNo, int limit) throws RemoteException, CassandraExplorerAdminCassandraExplorerException {
        return this.explorerAdminStub.getColumnPaginateSlice(keyspace, columnFamily, rowName, startingNo, limit);
    }

    public int getNoOfColumns(String keyspace, String columnFamily, String rowName) throws RemoteException, CassandraExplorerAdminCassandraExplorerException {
        return this.explorerAdminStub.getNoOfColumns(keyspace, columnFamily, rowName);
    }

    public Column[] searchColumns(String keyspace, String columnFamily, String rowName, String searchKey, int startingNo, int limit) throws RemoteException, CassandraExplorerAdminCassandraExplorerException {
        return this.explorerAdminStub.searchColumns(keyspace, columnFamily, rowName, searchKey, startingNo, limit);
    }

    public int getNoOfFilteredResultsoforColumns(String keyspace, String columnFamily, String rowName, String searchKey) throws RemoteException, CassandraExplorerAdminCassandraExplorerException {
        return this.explorerAdminStub.getNoOfColumnSearchResults(keyspace, columnFamily, rowName, searchKey);
    }

    public Row[] getPaginateSliceforRows(String keyspace, String columnFamily, int startingNo, int limit) throws RemoteException, CassandraExplorerAdminCassandraExplorerException {
        return this.explorerAdminStub.getRowPaginateSlice(keyspace, columnFamily, startingNo, limit);
    }

    public Row[] searchRows(String keyspace, String columnFamily, String searchKey, int startingNo, int limit) throws RemoteException, CassandraExplorerAdminCassandraExplorerException {
        return this.explorerAdminStub.searchRows(keyspace, columnFamily, searchKey, startingNo, limit);
    }

    public int getNoOfFilteredResultsoforRows(String keyspace, String columnFamily, String searchKey) throws RemoteException, CassandraExplorerAdminCassandraExplorerException {
        return this.explorerAdminStub.getNoOfRowSearchResults(keyspace, columnFamily, searchKey);
    }

    public boolean connectToCassandraCluster(String clusterName, String connectionUrl, String userName, String password) throws CassandraExplorerAdminCassandraExplorerException, RemoteException {
        return this.explorerAdminStub.connectToCassandraCluster(clusterName, connectionUrl, userName, password);
    }

    public String[] getKeyspaces() throws CassandraExplorerAdminCassandraExplorerException, RemoteException {
        return this.explorerAdminStub.getKeyspaces();
    }

    public String[] getColumnFamilies(String keyspace) throws CassandraExplorerAdminCassandraExplorerException, RemoteException {
        return this.explorerAdminStub.getColumnFamilies(keyspace);
    }

    public int getNoOfRows(String keyspace, String columnFamily) throws CassandraExplorerAdminCassandraExplorerException, RemoteException {
        return this.explorerAdminStub.getNoOfRows(keyspace, columnFamily);
    }
}

