/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.cassandra.io.ISerializer;

public class EstimatedHistogram {
    public static EstimatedHistogramSerializer serializer = new EstimatedHistogramSerializer();
    private long[] bucketOffsets;
    final AtomicLongArray buckets;

    public EstimatedHistogram() {
        this(90);
    }

    public EstimatedHistogram(int bucketCount) {
        this.makeOffsets(bucketCount);
        this.buckets = new AtomicLongArray(this.bucketOffsets.length + 1);
    }

    public EstimatedHistogram(long[] offsets, long[] bucketData) {
        assert (bucketData.length == offsets.length + 1);
        this.bucketOffsets = offsets;
        this.buckets = new AtomicLongArray(bucketData);
    }

    private void makeOffsets(int size) {
        long last;
        this.bucketOffsets = new long[size];
        this.bucketOffsets[0] = last = 1L;
        for (int i = 1; i < size; ++i) {
            long next = Math.round((double)last * 1.2);
            if (next == last) {
                // empty if block
            }
            this.bucketOffsets[i] = ++next;
            last = next;
        }
    }

    public long[] getBucketOffsets() {
        return this.bucketOffsets;
    }

    public void add(long n) {
        int index = Arrays.binarySearch(this.bucketOffsets, n);
        if (index < 0) {
            index = -index - 1;
        }
        this.buckets.incrementAndGet(index);
    }

    long get(int bucket) {
        return this.buckets.get(bucket);
    }

    public long[] getBuckets(boolean reset) {
        int i;
        long[] rv = new long[this.buckets.length()];
        for (i = 0; i < this.buckets.length(); ++i) {
            rv[i] = this.buckets.get(i);
        }
        if (reset) {
            for (i = 0; i < this.buckets.length(); ++i) {
                this.buckets.set(i, 0L);
            }
        }
        return rv;
    }

    public long min() {
        for (int i = 0; i < this.buckets.length(); ++i) {
            if (this.buckets.get(i) <= 0L) continue;
            return i == 0 ? 0L : 1L + this.bucketOffsets[i - 1];
        }
        return 0L;
    }

    public long max() {
        int lastBucket = this.buckets.length() - 1;
        if (this.buckets.get(lastBucket) > 0L) {
            return Long.MAX_VALUE;
        }
        for (int i = lastBucket - 1; i >= 0; --i) {
            if (this.buckets.get(i) <= 0L) continue;
            return this.bucketOffsets[i];
        }
        return 0L;
    }

    public long mean() {
        int lastBucket = this.buckets.length() - 1;
        if (this.buckets.get(lastBucket) > 0L) {
            throw new IllegalStateException("Unable to compute ceiling for max when histogram overflowed");
        }
        long elements = 0L;
        long sum = 0L;
        for (int i = 0; i < lastBucket; ++i) {
            elements += this.buckets.get(i);
            sum += this.buckets.get(i) * this.bucketOffsets[i];
        }
        return (long)Math.ceil((double)sum / (double)elements);
    }

    public long count() {
        long sum = 0L;
        for (int i = 0; i < this.buckets.length(); ++i) {
            sum += this.buckets.get(i);
        }
        return sum;
    }

    public boolean isOverflowed() {
        return this.buckets.get(this.buckets.length() - 1) > 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EstimatedHistogram)) {
            return false;
        }
        EstimatedHistogram that = (EstimatedHistogram)o;
        return Arrays.equals(this.getBucketOffsets(), that.getBucketOffsets()) && Arrays.equals(this.getBuckets(false), that.getBuckets(false));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getBucketOffsets(), this.getBuckets(false)});
    }

    public static class EstimatedHistogramSerializer
    implements ISerializer<EstimatedHistogram> {
        @Override
        public void serialize(EstimatedHistogram eh, DataOutput dos) throws IOException {
            long[] offsets = eh.getBucketOffsets();
            long[] buckets = eh.getBuckets(false);
            dos.writeInt(buckets.length);
            for (int i = 0; i < buckets.length; ++i) {
                dos.writeLong(offsets[i == 0 ? 0 : i - 1]);
                dos.writeLong(buckets[i]);
            }
        }

        @Override
        public EstimatedHistogram deserialize(DataInput dis) throws IOException {
            int size = dis.readInt();
            long[] offsets = new long[size - 1];
            long[] buckets = new long[size];
            for (int i = 0; i < size; ++i) {
                offsets[i == 0 ? 0 : i - 1] = dis.readLong();
                buckets[i] = dis.readLong();
            }
            return new EstimatedHistogram(offsets, buckets);
        }

        @Override
        public long serializedSize(EstimatedHistogram object) {
            throw new UnsupportedOperationException();
        }
    }
}

