/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.FastByteArrayOutputStream;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageProducer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

class StreamReply
implements MessageProducer {
    public static final IVersionedSerializer<StreamReply> serializer = new FileStatusSerializer();
    public final long sessionId;
    public final String file;
    public final Status action;

    public StreamReply(String file, long sessionId, Status action) {
        this.file = file;
        this.action = action;
        this.sessionId = sessionId;
    }

    @Override
    public Message getMessage(Integer version) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        serializer.serialize(this, dos, version);
        return new Message(FBUtilities.getBroadcastAddress(), StorageService.Verb.STREAM_REPLY, bos.toByteArray(), version);
    }

    public String toString() {
        return "StreamReply(sessionId=" + this.sessionId + ", file='" + this.file + '\'' + ", action=" + (Object)((Object)this.action) + ')';
    }

    private static class FileStatusSerializer
    implements IVersionedSerializer<StreamReply> {
        private FileStatusSerializer() {
        }

        @Override
        public void serialize(StreamReply reply, DataOutput dos, int version) throws IOException {
            dos.writeLong(reply.sessionId);
            dos.writeUTF(reply.file);
            dos.writeInt(reply.action.ordinal());
        }

        @Override
        public StreamReply deserialize(DataInput dis, int version) throws IOException {
            long sessionId = dis.readLong();
            String targetFile = dis.readUTF();
            Status action = Status.values()[dis.readInt()];
            return new StreamReply(targetFile, sessionId, action);
        }

        @Override
        public long serializedSize(StreamReply streamReply, int version) {
            throw new UnsupportedOperationException();
        }
    }

    static enum Status {
        FILE_FINISHED,
        FILE_RETRY,
        SESSION_FINISHED,
        SESSION_FAILURE;

    }
}

