/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.service.ClientState;

public class SocketSessionManagementService {
    public static final SocketSessionManagementService instance = new SocketSessionManagementService();
    public static final ThreadLocal<SocketAddress> remoteSocket = new ThreadLocal();
    private Map<SocketAddress, ClientState> activeSocketSessions = new ConcurrentHashMap<SocketAddress, ClientState>();

    public ClientState get(SocketAddress key) {
        ClientState retval = null;
        if (null != key) {
            retval = this.activeSocketSessions.get(key);
        }
        return retval;
    }

    public void put(SocketAddress key, ClientState value) {
        if (null != key && null != value) {
            this.activeSocketSessions.put(key, value);
        }
    }

    public boolean remove(SocketAddress key) {
        assert (null != key);
        boolean retval = false;
        if (null != this.activeSocketSessions.remove(key)) {
            retval = true;
        }
        return retval;
    }

    public void clear() {
        this.activeSocketSessions.clear();
    }
}

