/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.auth.Action;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql.CQLStatement;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.utils.SemanticVersion;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientState {
    private static final int MAX_CACHE_PREPARED = 10000;
    private static Logger logger = LoggerFactory.getLogger(ClientState.class);
    public static final SemanticVersion DEFAULT_CQL_VERSION = org.apache.cassandra.cql.QueryProcessor.CQL_VERSION;
    private AuthenticatedUser user;
    private String keyspace;
    private String qualifiedKeyspace;
    private String prefix;
    private final List<Object> resource = new ArrayList<Object>();
    private SemanticVersion cqlVersion = DEFAULT_CQL_VERSION;
    private Map<Integer, CQLStatement> prepared = new LinkedHashMap<Integer, CQLStatement>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, CQLStatement> eldest) {
            return this.size() > 10000;
        }
    };
    private Map<Integer, org.apache.cassandra.cql3.CQLStatement> cql3Prepared = new LinkedHashMap<Integer, org.apache.cassandra.cql3.CQLStatement>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, org.apache.cassandra.cql3.CQLStatement> eldest) {
            return this.size() > 10000;
        }
    };
    private long clock;

    public ClientState() {
        this.reset();
    }

    public Map<Integer, CQLStatement> getPrepared() {
        return this.prepared;
    }

    public Map<Integer, org.apache.cassandra.cql3.CQLStatement> getCQL3Prepared() {
        return this.cql3Prepared;
    }

    public String getRawKeyspace() {
        return this.keyspace;
    }

    public String getKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("no keyspace has been specified");
        }
        return this.keyspace;
    }

    public void setKeyspace(String ks) throws InvalidRequestException {
        if (Schema.instance.getKSMetaData(ks) == null) {
            throw new InvalidRequestException("Keyspace '" + ks + "' does not exist");
        }
        this.keyspace = ks;
    }

    public String getSchedulingValue() {
        switch (DatabaseDescriptor.getRequestSchedulerId()) {
            case keyspace: {
                return this.keyspace;
            }
        }
        return "default";
    }

    public void login(Map<? extends CharSequence, ? extends CharSequence> credentials) throws AuthenticationException {
        AuthenticatedUser user = DatabaseDescriptor.getAuthenticator().authenticate(credentials);
        if (logger.isDebugEnabled()) {
            logger.debug("logged in: {}", (Object)user);
        }
        this.user = user;
        this.setQualifiedKeyspace();
    }

    public void logout() {
        if (logger.isDebugEnabled()) {
            logger.debug("logged out: {}", (Object)this.user);
        }
        this.reset();
    }

    private void resourceClear() {
        this.resource.clear();
        this.resource.add("cassandra");
        this.resource.add("keyspaces");
    }

    public void reset() {
        this.user = DatabaseDescriptor.getAuthenticator().defaultUser();
        this.keyspace = null;
        this.qualifiedKeyspace = null;
        this.prefix = null;
        this.resourceClear();
        this.prepared.clear();
        this.cql3Prepared.clear();
    }

    public void hasKeyspaceSchemaAccess(Permission perm, Action action) throws InvalidRequestException {
        this.validateLogin();
        this.resourceClear();
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource, action);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public void hasColumnFamilySchemaAccess(Permission perm, Action action) throws InvalidRequestException {
        this.validateLogin();
        this.validateKeyspace();
        if (this.keyspace.equalsIgnoreCase("system") && perm == Permission.WRITE) {
            throw new InvalidRequestException("system keyspace is not user-modifiable");
        }
        this.resourceClear();
        this.resource.add(this.keyspace);
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource, action);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public void hasColumnFamilyAccess(String columnFamily, Permission perm, Action action) throws InvalidRequestException {
        this.hasColumnFamilyAccess(this.keyspace, columnFamily, perm, action);
    }

    public void hasColumnFamilyAccess(String keyspace, String columnFamily, Permission perm, Action action) throws InvalidRequestException {
        this.validateLogin();
        this.validateKeyspace();
        this.resourceClear();
        this.resource.add(keyspace);
        this.resource.add(columnFamily);
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource, action);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public String getResolvedKeyspace() {
        this.qualifiedKeyspace = this.resolveKeyspace(this.keyspace);
        return this.qualifiedKeyspace == null ? this.keyspace : this.qualifiedKeyspace;
    }

    public String resolveKeyspace(String keyspaceTobeResolved) {
        return this.prefix == null || this.prefix.equals("carbon_super_") || keyspaceTobeResolved.startsWith(this.prefix) ? keyspaceTobeResolved : this.prefix + keyspaceTobeResolved;
    }

    public String getDomainNameLessKeyspace(String keyspaceWithDomainName) {
        return this.prefix == null || !keyspaceWithDomainName.startsWith(this.prefix) ? keyspaceWithDomainName : keyspaceWithDomainName.substring(this.prefix.length());
    }

    private void validateLogin() throws InvalidRequestException {
        if (this.user == null) {
            throw new InvalidRequestException("You have not logged in");
        }
    }

    private void validateKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("You have not set a keyspace for this session");
        }
    }

    private static void hasAccess(AuthenticatedUser user, Set<Permission> perms, Permission perm, List<Object> resource) throws InvalidRequestException {
        if (perms.contains((Object)perm)) {
            return;
        }
        throw new InvalidRequestException(String.format("%s does not have permission %s for %s", new Object[]{user, perm, Resources.toString(resource)}));
    }

    private void setQualifiedKeyspace() {
        if (this.user != null && this.user.domainName != null) {
            if (this.prefix == null) {
                this.prefix = this.user.domainName + "_";
                this.prefix = this.prefix.replace(".", "_");
                this.prefix = this.prefix.replace("-", "z");
            }
            if (this.keyspace != null) {
                this.qualifiedKeyspace = this.prefix.equals("carbon_super_") ? this.keyspace : this.prefix + this.keyspace;
            }
        }
    }

    public long getTimestamp() {
        long current = System.currentTimeMillis() * 1000L;
        this.clock = this.clock >= current ? this.clock + 1L : current;
        return this.clock;
    }

    public void setCQLVersion(String str) throws InvalidRequestException {
        SemanticVersion version;
        try {
            version = new SemanticVersion(str);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        SemanticVersion cql = org.apache.cassandra.cql.QueryProcessor.CQL_VERSION;
        SemanticVersion cql3 = QueryProcessor.CQL_VERSION;
        if (version.isSupportedBy(cql)) {
            this.cqlVersion = cql;
        } else if (version.isSupportedBy(cql3)) {
            this.cqlVersion = cql3;
        } else {
            throw new InvalidRequestException(String.format("Provided version %s is not supported by this server (supported: %s)", version, StringUtils.join((Object[])ClientState.getCQLSupportedVersion(), (String)", ")));
        }
    }

    public SemanticVersion getCQLVersion() {
        return this.cqlVersion;
    }

    public static SemanticVersion[] getCQLSupportedVersion() {
        SemanticVersion cql = org.apache.cassandra.cql.QueryProcessor.CQL_VERSION;
        SemanticVersion cql3 = QueryProcessor.CQL_VERSION;
        return new SemanticVersion[]{cql, cql3};
    }
}

