/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigestAck2Message;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDigestAck2VerbHandler
implements IVerbHandler {
    private static Logger logger_ = LoggerFactory.getLogger(GossipDigestAck2VerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        GossipDigestAck2Message gDigestAck2Message;
        if (logger_.isTraceEnabled()) {
            InetAddress from = message.getFrom();
            logger_.trace("Received a GossipDigestAck2Message from {}", (Object)from);
        }
        byte[] bytes = message.getMessageBody();
        DataInputStream dis = new DataInputStream(new FastByteArrayInputStream(bytes));
        try {
            gDigestAck2Message = GossipDigestAck2Message.serializer().deserialize(dis, message.getVersion());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map<InetAddress, EndpointState> remoteEpStateMap = gDigestAck2Message.getEndpointStateMap();
        Gossiper.instance.notifyFailureDetector(remoteEpStateMap);
        Gossiper.instance.applyStateLocally(remoteEpStateMap);
    }
}

