/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.db.DefsTable;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionsUpdateVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionsUpdateVerbHandler.class);

    @Override
    public void doVerb(final Message message, String id) {
        logger.debug("Received schema mutation push from " + message.getFrom());
        StageManager.getStage(Stage.MIGRATION).submit(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                DefsTable.mergeRemoteSchema(message.getMessageBody(), message.getVersion());
            }
        });
    }
}

