/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.InvalidRequestException;

public class DropIndexStatement
extends SchemaAlteringStatement {
    public final CharSequence index;

    public DropIndexStatement(String indexName) {
        super(new CFName());
        this.index = indexName;
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        CFMetaData cfm;
        CFMetaData updatedCfm = null;
        KSMetaData ksm = Schema.instance.getTableDefinition(this.keyspace());
        Iterator<CFMetaData> i$ = ksm.cfMetaData().values().iterator();
        while (i$.hasNext() && (updatedCfm = this.getUpdatedCFMetadata(cfm = i$.next())) == null) {
        }
        if (updatedCfm == null) {
            throw new InvalidRequestException("Index '" + this.index + "' could not be found in any of the column families of keyspace '" + this.keyspace() + "'");
        }
        MigrationManager.announceColumnFamilyUpdate(updatedCfm);
    }

    private CFMetaData getUpdatedCFMetadata(CFMetaData cfm) throws InvalidRequestException {
        for (ColumnDefinition column : cfm.getColumn_metadata().values()) {
            if (column.getIndexType() == null || column.getIndexName() == null || !column.getIndexName().equals(this.index)) continue;
            column.setIndexName(null);
            column.setIndexType(null, null);
            return cfm;
        }
        return null;
    }
}

