/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.explorer.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesQuery;
import me.prettyprint.hector.api.query.SliceQuery;
import org.wso2.carbon.cassandra.explorer.connection.ConnectionManager;
import org.wso2.carbon.cassandra.explorer.data.Column;
import org.wso2.carbon.cassandra.explorer.data.Row;
import org.wso2.carbon.cassandra.explorer.exception.CassandraExplorerException;
import org.wso2.carbon.core.AbstractAdmin;

public class CassandraExplorerAdmin
extends AbstractAdmin {
    private static final StringSerializer stringSerializer = new StringSerializer();

    public int getNoOfRows(String keyspaceName, String columnFamily) throws CassandraExplorerException {
        Cluster cluster = ConnectionManager.getCluster();
        Keyspace keyspace = ConnectionManager.getKeyspace(cluster, keyspaceName);
        RangeSlicesQuery rangeSlicesQuery = HFactory.createRangeSlicesQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        rangeSlicesQuery.setColumnFamily(columnFamily);
        rangeSlicesQuery.setKeys((Object)"", (Object)"");
        rangeSlicesQuery.setRowCount(Integer.MAX_VALUE);
        rangeSlicesQuery.setReturnKeysOnly();
        QueryResult result = rangeSlicesQuery.execute();
        return ((OrderedRows)result.get()).getCount();
    }

    public Row[] getRowPaginateSlice(String keyspaceName, String columnFamily, int startingNo, int limit) throws CassandraExplorerException {
        Cluster cluster = ConnectionManager.getCluster();
        Keyspace keyspace = ConnectionManager.getKeyspace(cluster, keyspaceName);
        RangeSlicesQuery rangeSlicesQuery = HFactory.createRangeSlicesQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        rangeSlicesQuery.setColumnFamily(columnFamily);
        rangeSlicesQuery.setKeys((Object)"", (Object)"");
        rangeSlicesQuery.setRange((Object)"", (Object)"", false, 3);
        rangeSlicesQuery.setRowCount(startingNo + 1);
        ArrayList<Row> rowlist = new ArrayList<Row>();
        QueryResult result = rangeSlicesQuery.execute();
        String endKey = "";
        if (((OrderedRows)result.get()).peekLast() != null) {
            endKey = (String)((OrderedRows)result.get()).peekLast().getKey();
        }
        rangeSlicesQuery.setRowCount(limit);
        rangeSlicesQuery.setKeys((Object)endKey, (Object)"");
        result = rangeSlicesQuery.execute();
        for (me.prettyprint.hector.api.beans.Row cassandraRow : ((OrderedRows)result.get()).getList()) {
            Row row = new Row();
            row.setRowId(this.cleanNonXmlChars(cassandraRow.getKey().toString()));
            List hColumnsList = cassandraRow.getColumnSlice().getColumns();
            Column[] columns = new Column[hColumnsList.size()];
            for (int i = 0; i < hColumnsList.size() && i != 3; ++i) {
                Column column = new Column();
                column.setName(this.cleanNonXmlChars((String)((HColumn)hColumnsList.get(i)).getName()));
                column.setValue(this.cleanNonXmlChars((String)((HColumn)hColumnsList.get(i)).getValue()));
                columns[i] = column;
            }
            row.setColumns(columns);
            rowlist.add(row);
        }
        Row[] rows = new Row[rowlist.size()];
        return rowlist.toArray(rows);
    }

    public Row[] searchRows(String keyspaceName, String columnFamily, String searchKey, int startingNo, int limit) throws CassandraExplorerException {
        Cluster cluster = ConnectionManager.getCluster();
        Keyspace keyspace = ConnectionManager.getKeyspace(cluster, keyspaceName);
        RangeSlicesQuery rangeSlicesQuery = HFactory.createRangeSlicesQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        rangeSlicesQuery.setColumnFamily(columnFamily);
        rangeSlicesQuery.setKeys((Object)"", (Object)"");
        rangeSlicesQuery.setRange((Object)"", (Object)"", false, 3);
        rangeSlicesQuery.setRowCount(Integer.MAX_VALUE);
        ArrayList<Row> rowlist = new ArrayList<Row>();
        QueryResult result = rangeSlicesQuery.execute();
        for (me.prettyprint.hector.api.beans.Row cassandraRow : ((OrderedRows)result.get()).getList()) {
            Row row = new Row();
            if (!cassandraRow.getKey().toString().contains(searchKey)) continue;
            row.setRowId(cassandraRow.getKey().toString());
            List hColumnsList = cassandraRow.getColumnSlice().getColumns();
            Column[] columns = new Column[hColumnsList.size()];
            for (int i = 0; i < hColumnsList.size() && i != 3; ++i) {
                Column column = new Column();
                column.setName(this.cleanNonXmlChars((String)((HColumn)hColumnsList.get(i)).getName()));
                column.setValue(this.cleanNonXmlChars((String)((HColumn)hColumnsList.get(i)).getValue()));
                columns[i] = column;
            }
            row.setColumns(columns);
            rowlist.add(row);
        }
        if (rowlist.size() < limit) {
            limit = rowlist.size();
        }
        if (limit + startingNo > rowlist.size()) {
            limit = rowlist.size() - startingNo;
        }
        Row[] rows = new Row[limit];
        for (int i = 0; i < limit; ++i) {
            rows[i] = (Row)rowlist.get(startingNo + i);
        }
        return rows;
    }

    public int getNoOfRowSearchResults(String keyspaceName, String columnFamily, String searchKey) throws CassandraExplorerException {
        Cluster cluster = ConnectionManager.getCluster();
        Keyspace keyspace = ConnectionManager.getKeyspace(cluster, keyspaceName);
        RangeSlicesQuery rangeSlicesQuery = HFactory.createRangeSlicesQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        rangeSlicesQuery.setColumnFamily(columnFamily);
        rangeSlicesQuery.setKeys((Object)"", (Object)"");
        rangeSlicesQuery.setReturnKeysOnly();
        rangeSlicesQuery.setRowCount(Integer.MAX_VALUE);
        ArrayList<Row> rowlist = new ArrayList<Row>();
        QueryResult result = rangeSlicesQuery.execute();
        for (me.prettyprint.hector.api.beans.Row cassandraRow : ((OrderedRows)result.get()).getList()) {
            Row row = new Row();
            if (!cassandraRow.getKey().toString().contains(searchKey)) continue;
            rowlist.add(row);
        }
        return rowlist.size();
    }

    public Column[] searchColumns(String keyspaceName, String columnFamily, String rowName, String searchKey, int startingNo, int limit) throws CassandraExplorerException {
        Cluster cluster = ConnectionManager.getCluster();
        Keyspace keyspace = ConnectionManager.getKeyspace(cluster, keyspaceName);
        SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        sliceQuery.setColumnFamily(columnFamily);
        sliceQuery.setKey((Object)rowName);
        sliceQuery.setRange((Object)"", (Object)"", false, Integer.MAX_VALUE);
        QueryResult result = sliceQuery.execute();
        ArrayList<Column> columnsList = new ArrayList<Column>();
        List hColumnsList = ((ColumnSlice)result.get()).getColumns();
        for (HColumn hColumn : hColumnsList) {
            Column column = new Column();
            column.setName(this.cleanNonXmlChars(hColumn.getName().toString()));
            column.setValue(this.cleanNonXmlChars(hColumn.getValue().toString()));
            column.setTimeStamp(hColumn.getClock());
            if (!column.getName().contains(searchKey) && !column.getValue().contains(searchKey)) continue;
            columnsList.add(column);
        }
        if (columnsList.size() < limit) {
            limit = columnsList.size();
        }
        Column[] columnArray = new Column[limit];
        for (int i = 0; i < limit; ++i) {
            columnArray[i] = (Column)columnsList.get(startingNo + i);
        }
        return columnArray;
    }

    public int getNoOfColumnSearchResults(String keyspaceName, String columnFamily, String rowName, String searchKey) throws CassandraExplorerException {
        Cluster cluster = ConnectionManager.getCluster();
        Keyspace keyspace = ConnectionManager.getKeyspace(cluster, keyspaceName);
        SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        sliceQuery.setColumnFamily(columnFamily);
        sliceQuery.setKey((Object)rowName);
        sliceQuery.setRange((Object)"", (Object)"", false, Integer.MAX_VALUE);
        QueryResult result = sliceQuery.execute();
        ArrayList<Column> columnsList = new ArrayList<Column>();
        List hColumnsList = ((ColumnSlice)result.get()).getColumns();
        for (HColumn hColumn : hColumnsList) {
            Column column = new Column();
            if (!column.getName().contains(searchKey) && !column.getValue().contains(searchKey)) continue;
            columnsList.add(column);
        }
        return columnsList.size();
    }

    public Column[] getColumnPaginateSlice(String keyspaceName, String columnFamily, String rowName, int startingNo, int limit) throws CassandraExplorerException {
        QueryResult result;
        Cluster cluster = ConnectionManager.getCluster();
        Keyspace keyspace = ConnectionManager.getKeyspace(cluster, keyspaceName);
        SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        sliceQuery.setColumnFamily(columnFamily);
        sliceQuery.setKey((Object)rowName);
        if (startingNo != 0) {
            sliceQuery.setRange((Object)"", (Object)"", false, startingNo + 1);
            result = sliceQuery.execute();
            List tmpHColumnsList = ((ColumnSlice)result.get()).getColumns();
            HColumn startingColumn = (HColumn)tmpHColumnsList.get(tmpHColumnsList.size() - 1);
            String startingColumnName = (String)startingColumn.getName();
            sliceQuery.setRange((Object)startingColumnName, (Object)"", false, limit);
        } else {
            sliceQuery.setRange((Object)"", (Object)"", false, limit);
        }
        result = sliceQuery.execute();
        ArrayList<Column> columnsList = new ArrayList<Column>();
        List hColumnsList = ((ColumnSlice)result.get()).getColumns();
        for (HColumn hColumn : hColumnsList) {
            Column column = new Column();
            column.setName(this.cleanNonXmlChars(hColumn.getName().toString()));
            column.setValue(this.cleanNonXmlChars(hColumn.getValue().toString()));
            column.setTimeStamp(hColumn.getClock());
            columnsList.add(column);
        }
        Column[] columnArray = new Column[columnsList.size()];
        return columnsList.toArray(columnArray);
    }

    public int getNoOfColumns(String keyspaceName, String columnFamily, String rowName) throws CassandraExplorerException {
        Cluster cluster = ConnectionManager.getCluster();
        Keyspace keyspace = ConnectionManager.getKeyspace(cluster, keyspaceName);
        SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
        sliceQuery.setColumnFamily(columnFamily);
        sliceQuery.setKey((Object)rowName);
        sliceQuery.setRange((Object)"", (Object)"", false, Integer.MAX_VALUE);
        QueryResult result = sliceQuery.execute();
        List hColumnsList = ((ColumnSlice)result.get()).getColumns();
        return hColumnsList.size();
    }

    public boolean connectToCassandraCluster(String clusterName, String connectionUrl, String userName, String password) throws CassandraExplorerException {
        HashMap<String, String> credentials = new HashMap<String, String>();
        if (connectionUrl == null || connectionUrl.isEmpty()) {
            throw new CassandraExplorerException("Connection URL is empty. Please provide Cassandra Connection URL to connect");
        }
        if (userName != null && !userName.isEmpty() && password != null) {
            credentials.put("username", userName);
            credentials.put("password", password);
        }
        String parsedClusterName = "";
        if (clusterName.contains(":")) {
            parsedClusterName = clusterName.replace(":", "_");
        }
        ConnectionManager connectionManager = new ConnectionManager(parsedClusterName, connectionUrl, credentials);
        return connectionManager.isConnected();
    }

    public String[] getKeyspaces() throws CassandraExplorerException {
        Cluster cluster = ConnectionManager.getCluster();
        Iterator keyspaceItr = null;
        try {
            keyspaceItr = cluster.describeKeyspaces().iterator();
        }
        catch (HectorException exception) {
            throw new CassandraExplorerException("Error in retrieving keyspaces. " + exception.getMessage(), exception);
        }
        ArrayList<String> keyspaceNames = new ArrayList<String>();
        while (keyspaceItr != null && keyspaceItr.hasNext()) {
            keyspaceNames.add(((KeyspaceDefinition)keyspaceItr.next()).getName());
        }
        String[] keySpaceNameArray = new String[keyspaceNames.size()];
        return keyspaceNames.toArray(keySpaceNameArray);
    }

    public String[] getColumnFamilies(String keySpace) throws CassandraExplorerException {
        Cluster cluster = ConnectionManager.getCluster();
        Iterator keyspaceItr = cluster.describeKeyspace(keySpace).getCfDefs().iterator();
        ArrayList<String> columnFamiliyNamesList = new ArrayList<String>();
        while (keyspaceItr.hasNext()) {
            columnFamiliyNamesList.add(((ColumnFamilyDefinition)keyspaceItr.next()).getName());
        }
        String[] keySpaceNameArray = new String[columnFamiliyNamesList.size()];
        return columnFamiliyNamesList.toArray(keySpaceNameArray);
    }

    private String cleanNonXmlChars(String value) {
        String parsedString = "";
        if (value != null) {
            parsedString = value.replaceAll("[\\x00-\\x09\\x0B\\x0C\\x0E-\\x1F\\x7F]", " ");
        }
        if (parsedString.trim().isEmpty()) {
            parsedString = "***Non displayable value***";
        }
        return parsedString;
    }
}

