/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.explorer.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import org.wso2.carbon.cassandra.explorer.exception.CassandraExplorerException;
import org.wso2.carbon.cassandra.explorer.session.ExplorerSessionManager;

public class ConnectionManager {
    private static final String EXPLORER_CLUSTER_CONNECTION = "connection";

    public ConnectionManager(String clusterName, String connectionUrl, Map<String, String> credentials) throws CassandraExplorerException {
        this.setCassandraCluster(clusterName, connectionUrl, credentials);
    }

    private void setCassandraCluster(String clusterName, String connectionUrl, Map<String, String> credentials) throws CassandraExplorerException {
        try {
            CassandraHostConfigurator hostConfigurator = new CassandraHostConfigurator(connectionUrl);
            hostConfigurator.setRetryDownedHosts(false);
            ThriftCluster cluster = new ThriftCluster(clusterName, hostConfigurator, credentials);
            ExplorerSessionManager.setSessionObject(EXPLORER_CLUSTER_CONNECTION, cluster);
        }
        catch (Exception exception) {
            throw new CassandraExplorerException(exception.getMessage(), exception.getCause());
        }
    }

    public List<Keyspace> getCassandraKeySpacesList(Cluster cluster) {
        List KeyspaceDefsList = cluster.describeKeyspaces();
        ArrayList<Keyspace> keyspaceList = new ArrayList<Keyspace>();
        for (KeyspaceDefinition keyspaceDefinition : KeyspaceDefsList) {
            keyspaceList.add(HFactory.createKeyspace((String)keyspaceDefinition.getName(), (Cluster)cluster));
        }
        return keyspaceList;
    }

    public static Keyspace getKeyspace(Cluster cluster, String keyspaceName) {
        return HFactory.createKeyspace((String)keyspaceName, (Cluster)cluster);
    }

    public static Cluster getCluster() throws CassandraExplorerException {
        Cluster cluster = (Cluster)ExplorerSessionManager.getSessionObject(EXPLORER_CLUSTER_CONNECTION);
        if (cluster != null) {
            return cluster;
        }
        throw new CassandraExplorerException("Cannot find a cluster, Please connect");
    }

    public boolean isConnected() {
        return ExplorerSessionManager.getSessionObject(EXPLORER_CLUSTER_CONNECTION) != null;
    }
}

