/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.BooleanSerializer;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.CompositeSerializer;
import me.prettyprint.cassandra.serializers.DateSerializer;
import me.prettyprint.cassandra.serializers.DoubleSerializer;
import me.prettyprint.cassandra.serializers.DynamicCompositeSerializer;
import me.prettyprint.cassandra.serializers.FloatSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.cassandra.service.template.AbstractTemplateUpdater;
import me.prettyprint.cassandra.service.template.ColumnFamilyTemplate;
import me.prettyprint.hector.api.ColumnFactory;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Composite;
import me.prettyprint.hector.api.beans.DynamicComposite;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.mutation.Mutator;

public class ColumnFamilyUpdater<K, N>
extends AbstractTemplateUpdater<K, N> {
    public ColumnFamilyUpdater(ColumnFamilyTemplate<K, N> template, ColumnFactory columnFactory) {
        super(template, columnFactory, template.createMutator());
    }

    public ColumnFamilyUpdater(ColumnFamilyTemplate<K, N> template, ColumnFactory columnFactory, Mutator<K> mutator) {
        super(template, columnFactory, mutator);
    }

    public void deleteColumn(N columnName) {
        this.mutator.addDeletion(this.getCurrentKey(), this.template.getColumnFamily(), columnName, this.template.getTopSerializer());
    }

    public void setString(N columnName, String value) {
        HColumn<N, String> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), StringSerializer.get());
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public void setUUID(N columnName, UUID value) {
        HColumn<N, UUID> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), UUIDSerializer.get());
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public void setLong(N columnName, Long value) {
        HColumn<N, Long> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), LongSerializer.get());
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public void setInteger(N columnName, Integer value) {
        HColumn<N, Integer> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), IntegerSerializer.get());
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public void setDouble(N columnName, Double value) {
        HColumn<N, Double> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), DoubleSerializer.get());
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public void setBoolean(N columnName, Boolean value) {
        HColumn<N, Boolean> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), BooleanSerializer.get());
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public void setByteArray(N columnName, byte[] value) {
        HColumn<N, byte[]> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), BytesArraySerializer.get());
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public void setByteBuffer(N columnName, ByteBuffer value) {
        HColumn<N, ByteBuffer> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), ByteBufferSerializer.get());
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public void setDate(N columnName, Date value) {
        HColumn<N, Date> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), DateSerializer.get());
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public <V> void setFloat(N columnName, float value) {
        HColumn<N, Float> column = this.columnFactory.createColumn(columnName, Float.valueOf(value), this.clock, this.template.getTopSerializer(), FloatSerializer.get());
    }

    public <V> void setComposite(N columnName, Composite composite) {
        HColumn<N, Composite> column = this.columnFactory.createColumn(columnName, composite, this.clock, this.template.getTopSerializer(), CompositeSerializer.get());
    }

    public <V> void setDynamicComposite(N columnName, DynamicComposite composite) {
        HColumn<N, DynamicComposite> column = this.columnFactory.createColumn(columnName, composite, this.clock, this.template.getTopSerializer(), DynamicCompositeSerializer.get());
    }

    public <V> void setValue(N columnName, V value, Serializer<V> serializer) {
        HColumn<N, V> column = this.columnFactory.createColumn(columnName, value, this.clock, this.template.getTopSerializer(), serializer);
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }

    public <V> void setColumn(HColumn<N, V> column) {
        this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
    }
}

