/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.model.AbstractSliceQuery;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.model.OrderedRowsImpl;
import me.prettyprint.cassandra.model.QueryResultImpl;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.query.QueryResult;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;

public class IndexedSlicesQuery<K, N, V>
extends AbstractSliceQuery<K, N, V, OrderedRows<K, N, V>> {
    private final IndexClause indexClause = new IndexClause();

    public IndexedSlicesQuery(Keyspace k, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(k, keySerializer, nameSerializer, valueSerializer);
    }

    public IndexedSlicesQuery<K, N, V> addEqualsExpression(N columnName, V columnValue) {
        this.indexClause.addToExpressions(new IndexExpression(this.columnNameSerializer.toByteBuffer(columnName), IndexOperator.EQ, this.valueSerializer.toByteBuffer(columnValue)));
        return this;
    }

    public IndexedSlicesQuery<K, N, V> addLteExpression(N columnName, V columnValue) {
        this.indexClause.addToExpressions(new IndexExpression(this.columnNameSerializer.toByteBuffer(columnName), IndexOperator.LTE, this.valueSerializer.toByteBuffer(columnValue)));
        return this;
    }

    public IndexedSlicesQuery<K, N, V> addGteExpression(N columnName, V columnValue) {
        this.indexClause.addToExpressions(new IndexExpression(this.columnNameSerializer.toByteBuffer(columnName), IndexOperator.GTE, this.valueSerializer.toByteBuffer(columnValue)));
        return this;
    }

    public IndexedSlicesQuery<K, N, V> addLtExpression(N columnName, V columnValue) {
        this.indexClause.addToExpressions(new IndexExpression(this.columnNameSerializer.toByteBuffer(columnName), IndexOperator.LT, this.valueSerializer.toByteBuffer(columnValue)));
        return this;
    }

    public IndexedSlicesQuery<K, N, V> addGtExpression(N columnName, V columnValue) {
        this.indexClause.addToExpressions(new IndexExpression(this.columnNameSerializer.toByteBuffer(columnName), IndexOperator.GT, this.valueSerializer.toByteBuffer(columnValue)));
        return this;
    }

    public IndexedSlicesQuery<K, N, V> setColumnNames(Collection<N> columnNames) {
        super.setColumnNames(columnNames);
        return this;
    }

    public IndexedSlicesQuery<K, N, V> setColumnNames(N ... columnNames) {
        super.setColumnNames(columnNames);
        return this;
    }

    public IndexedSlicesQuery<K, N, V> setRange(N start, N finish, boolean reversed, int count) {
        super.setRange(start, finish, reversed, count);
        return this;
    }

    public IndexedSlicesQuery<K, N, V> setReturnKeysOnly() {
        super.setReturnKeysOnly();
        return this;
    }

    public IndexedSlicesQuery<K, N, V> setStartKey(K startKey) {
        this.indexClause.setStart_key(this.keySerializer.toByteBuffer(startKey));
        return this;
    }

    public IndexedSlicesQuery<K, N, V> setColumnFamily(String cf) {
        super.setColumnFamily(cf);
        return this;
    }

    public IndexedSlicesQuery<K, N, V> setRowCount(int rowCount) {
        this.indexClause.setCount(rowCount);
        return this;
    }

    public int getRowCount() {
        return this.indexClause.getCount();
    }

    @Override
    public QueryResult<OrderedRows<K, N, V>> execute() {
        return new QueryResultImpl<OrderedRows<K, N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<OrderedRows<K, N, V>>(){

            @Override
            public OrderedRows<K, N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                Map<ByteBuffer, List<Column>> ret = null;
                if (!IndexedSlicesQuery.this.indexClause.isSetStart_key()) {
                    IndexedSlicesQuery.this.indexClause.setStart_key(new byte[0]);
                }
                ColumnParent columnParent = new ColumnParent(IndexedSlicesQuery.this.columnFamilyName);
                ret = ks.getIndexedSlices(columnParent, IndexedSlicesQuery.this.indexClause, IndexedSlicesQuery.this.getPredicate());
                Map thriftRet = IndexedSlicesQuery.this.keySerializer.fromBytesMap(ret);
                return new OrderedRowsImpl((LinkedHashMap)thriftRet, IndexedSlicesQuery.this.columnNameSerializer, IndexedSlicesQuery.this.valueSerializer);
            }
        }), this);
    }
}

