/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection.client;

import java.net.Socket;
import java.net.SocketException;
import javax.security.auth.Subject;
import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.connection.client.HThriftClient;
import me.prettyprint.cassandra.connection.security.KerberosHelper;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.hector.api.exceptions.HectorTransportException;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.ietf.jgss.GSSContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HKerberosThriftClient
extends HThriftClient
implements HClient {
    private static Logger log = LoggerFactory.getLogger(HKerberosThriftClient.class);
    private Subject kerberosTicket;
    private String servicePrincipalName;

    public HKerberosThriftClient(Subject kerberosTicket, CassandraHost cassandraHost, String servicePrincipalName) {
        super(cassandraHost);
        this.kerberosTicket = kerberosTicket;
        this.servicePrincipalName = servicePrincipalName;
    }

    @Override
    public HKerberosThriftClient open() {
        if (this.isOpen()) {
            throw new IllegalStateException("Open called on already open connection. You should not have gotten here.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating a new thrift connection to {}", (Object)this.cassandraHost);
        }
        TSocket socket = new TSocket(this.cassandraHost.getHost(), this.cassandraHost.getPort(), this.timeout);
        if (this.cassandraHost.getUseSocketKeepalive()) {
            try {
                socket.getSocket().setKeepAlive(true);
            }
            catch (SocketException se) {
                throw new HectorTransportException("Could not set SO_KEEPALIVE on socket: ", se);
            }
        }
        this.transport = this.cassandraHost.getUseThriftFramedTransport() ? new TFramedTransport((TTransport)socket) : socket;
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            log.debug("Unable to open transport to " + this.cassandraHost.getName());
            throw new HectorTransportException("Unable to open transport to " + this.cassandraHost.getName() + " , " + e.getLocalizedMessage(), e);
        }
        Socket internalSocket = socket.getSocket();
        GSSContext clientContext = KerberosHelper.authenticateClient(internalSocket, this.kerberosTicket, this.servicePrincipalName);
        if (clientContext == null) {
            this.close();
            throw new HectorTransportException("Kerberos context couldn't be established with client.");
        }
        return this;
    }
}

