/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.dataaccess;

import java.util.HashMap;
import java.util.Map;
import me.prettyprint.hector.api.Cluster;
import org.wso2.carbon.cassandra.dataaccess.BasicClusterRepository;
import org.wso2.carbon.cassandra.dataaccess.ClusterRepository;
import org.wso2.carbon.context.CarbonContext;

public class MultitenantClusterRepository
implements ClusterRepository {
    private Map<Integer, BasicClusterRepository> clusters = new HashMap<Integer, BasicClusterRepository>();

    @Override
    public Cluster getCluster(String owner, String clusterName) {
        BasicClusterRepository clusterRepository = this.getClusterRepository();
        if (clusterRepository != null) {
            return clusterRepository.getCluster(owner, clusterName);
        }
        return null;
    }

    @Override
    public void putCluster(String owner, String clusterName, Cluster cluster) {
        BasicClusterRepository clusterRepository = this.getClusterRepository();
        if (clusterRepository == null) {
            clusterRepository = new BasicClusterRepository();
            this.clusters.put(CarbonContext.getCurrentContext().getTenantId(), clusterRepository);
        }
        clusterRepository.putCluster(owner, clusterName, cluster);
    }

    @Override
    public void removeCluster(String owner, String clusterName) {
        BasicClusterRepository clusterRepository = this.getClusterRepository();
        if (clusterRepository != null) {
            clusterRepository.removeCluster(owner, clusterName);
        }
    }

    @Override
    public void removeClusters(String owner) {
        int tenantID = Integer.parseInt(owner);
        BasicClusterRepository clusterRepository = this.clusters.remove(tenantID);
        if (clusterRepository != null) {
            clusterRepository.removeAllClusters();
        }
    }

    @Override
    public void removeMyClusters() {
        BasicClusterRepository clusterRepository = this.removeClusterRepository();
        if (clusterRepository != null) {
            clusterRepository.removeMyClusters();
        }
    }

    @Override
    public void removeAllClusters() {
        for (BasicClusterRepository clusterRepository : this.clusters.values()) {
            clusterRepository.removeAllClusters();
        }
        this.clusters.clear();
    }

    private BasicClusterRepository getClusterRepository() {
        int tenantID = CarbonContext.getCurrentContext().getTenantId();
        return this.clusters.get(tenantID);
    }

    private BasicClusterRepository removeClusterRepository() {
        int tenantID = CarbonContext.getCurrentContext().getTenantId();
        return this.clusters.remove(tenantID);
    }
}

