/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cassandra.dataaccess;

import java.util.HashMap;
import java.util.Map;
import me.prettyprint.hector.api.Cluster;
import org.wso2.carbon.cassandra.dataaccess.ClusterRepository;
import org.wso2.carbon.context.CarbonContext;

public class BasicClusterRepository
implements ClusterRepository {
    private final Map<String, Map<String, Cluster>> clusters = new HashMap<String, Map<String, Cluster>>();

    @Override
    public Cluster getCluster(String owner, String clusterName) {
        Map<String, Cluster> clustersForUser = this.clusters.get(owner);
        if (clustersForUser != null) {
            return clustersForUser.get(clusterName);
        }
        return null;
    }

    @Override
    public void putCluster(String owner, String clusterName, Cluster cluster) {
        Map<String, Cluster> clustersForUser = this.clusters.get(owner);
        if (clustersForUser == null) {
            clustersForUser = new HashMap<String, Cluster>();
            this.clusters.put(owner, clustersForUser);
        }
        clustersForUser.put(clusterName, cluster);
    }

    @Override
    public void removeCluster(String owner, String clusterName) {
        Map<String, Cluster> clustersForUser = this.clusters.remove(owner);
        if (clustersForUser != null) {
            this.shutdownCluster(clustersForUser.remove(clusterName));
        }
    }

    @Override
    public void removeClusters(String owner) {
        Map<String, Cluster> clustersForUser = this.clusters.remove(owner);
        if (clustersForUser != null) {
            for (Cluster cluster : clustersForUser.values()) {
                this.shutdownCluster(cluster);
            }
        }
    }

    @Override
    public void removeMyClusters() {
        this.removeClusters(CarbonContext.getCurrentContext().getUsername());
    }

    @Override
    public void removeAllClusters() {
        for (Map<String, Cluster> clusterMap : this.clusters.values()) {
            for (Cluster cluster : clusterMap.values()) {
                this.shutdownCluster(cluster);
            }
        }
        this.clusters.clear();
    }

    private void shutdownCluster(Cluster cluster) {
        if (cluster != null) {
            cluster.getConnectionManager().shutdown();
        }
    }
}

