/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.service;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.wso2.carbon.caching.CachingComponentException;
import org.wso2.carbon.caching.CachingConfigData;
import org.wso2.carbon.caching.CachingPolicyUtils;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.ServicePersistenceManager;
import org.wso2.carbon.core.persistence.file.ModuleFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;

public class CachingConfigAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(CachingConfigAdminService.class);
    private static final String defaultCachingPolicyId = "WSO2CachingPolicy";
    private PersistenceFactory persistenceFactory;
    private ServicePersistenceManager servicePM;
    private ServiceGroupFilePersistenceManager serviceGroupFilePM;
    private ModuleFilePersistenceManager ModuleFilePM;
    private Registry configRegistry;
    private AxisConfiguration axisConfig = this.getAxisConfig();
    private CachingPolicyUtils cachingPolicyUtils;
    private static final String GLOBALLY_ENGAGED_PARAM_NAME = "globallyEngaged";
    private static final String GLOBALLY_ENGAGED_CUSTOM = "globallyEngagedCustom";
    private static final String ADMIN_SERVICE_PARAM_NAME = "adminService";
    private static final String HIDDEN_SERVICE_PARAM_NAME = "hiddenService";

    public CachingConfigAdminService() throws Exception {
        this.persistenceFactory = PersistenceFactory.getInstance((AxisConfiguration)this.axisConfig);
        this.servicePM = this.persistenceFactory.getServicePM();
        this.serviceGroupFilePM = this.persistenceFactory.getServiceGroupFilePM();
        this.ModuleFilePM = this.persistenceFactory.getModuleFilePM();
        this.cachingPolicyUtils = new CachingPolicyUtils();
        this.configRegistry = this.getConfigSystemRegistry();
    }

    public void engageCachingForService(String serviceName, CachingConfigData confData) throws CachingComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enabling caching for the service: " + serviceName));
        }
        AxisService axisService = this.retrieveAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        try {
            this.enableCaching(serviceGroupId, (AxisDescription)axisService, confData, serviceXPath);
        }
        catch (AxisFault af) {
            throw new CachingComponentException("errorEngagingModuleToService", new String[]{serviceName}, af, log);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Engaged caching for the Axis service: " + serviceName));
        }
    }

    public boolean engageCachingForOperation(String serviceName, String operationName, CachingConfigData confData) throws CachingComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enabling caching for the operation: " + operationName + " of service : " + serviceName));
        }
        AxisService axisService = this.retrieveAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        AxisModule cachingModule = this.axisConfig.getModule("wso2caching");
        if (axisService.isEngaged(cachingModule)) {
            return true;
        }
        AxisOperation operation = axisService.getOperation(new QName(operationName));
        String operationXPath = PersistenceUtils.getResourcePath((AxisOperation)operation);
        try {
            this.enableCaching(serviceGroupId, (AxisDescription)operation, confData, operationXPath);
        }
        catch (AxisFault af) {
            throw new CachingComponentException("errorEngagingModuleToOperation", new String[]{operationName}, af, log);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Engaged caching for the Axis operation: " + serviceName + " of service : " + serviceName));
        }
        return false;
    }

    private void enableCaching(String serviceGroupId, AxisDescription description, CachingConfigData confData, String engagementPath) throws CachingComponentException, AxisFault {
        AxisModule cachingModule = this.axisConfig.getModule("wso2caching");
        try {
            boolean registryTransactionStarted;
            boolean transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            if (!(registryTransactionStarted = Transaction.isStarted())) {
                this.configRegistry.beginTransaction();
            }
            List associations = this.serviceGroupFilePM.getAll(serviceGroupId, engagementPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
            boolean associationExist = false;
            String version = cachingModule.getVersion().toString();
            if (cachingModule.getVersion() == null) {
                version = "undefined";
            }
            for (Object node : associations) {
                OMElement association = (OMElement)node;
                if (!association.getAttributeValue(new QName("name")).equals(cachingModule.getName()) || !association.getAttributeValue(new QName("version")).equals(version)) continue;
                associationExist = true;
                break;
            }
            if (!associationExist) {
                this.serviceGroupFilePM.put(serviceGroupId, PersistenceUtils.createModule((String)cachingModule.getName(), (String)version, (String)"engagedModules"), engagementPath);
            }
            Policy policy = confData.toPolicy();
            this.handleNewPolicyAddition(policy, description.getPolicySubject(), confData);
            try {
                String policyType;
                AxisService service;
                boolean isProxyService = false;
                String registryEngagementPath = "";
                if (description instanceof AxisService) {
                    service = (AxisService)description;
                    isProxyService = PersistenceUtils.isProxyService((AxisService)((AxisService)description));
                    registryEngagementPath = "/repository/axis2/service-groups/" + service.getAxisServiceGroup().getServiceGroupName() + "/services/" + service.getName();
                } else if (description instanceof AxisOperation) {
                    service = ((AxisOperation)description).getAxisService();
                    isProxyService = PersistenceUtils.isProxyService((AxisService)service);
                    registryEngagementPath = "/repository/axis2/service-groups/" + service.getAxisServiceGroup().getServiceGroupName() + "/services/" + service.getName() + "/operations/" + ((AxisOperation)description).getName().getLocalPart();
                } else {
                    log.debug((Object)"Proxy services - AxisDescription is neither an instance of AxisService nor AxisOperation.");
                }
                if (isProxyService) {
                    policyType = "3";
                    String servicePath = registryEngagementPath;
                    if (description instanceof AxisOperation) {
                        servicePath = registryEngagementPath.substring(0, registryEngagementPath.indexOf("/operations/"));
                        policyType = "4";
                    }
                    this.persistenceFactory.getServicePM().persistPolicyToRegistry(policy, policyType, servicePath);
                }
                policyType = "3";
                String policyPath = engagementPath;
                if (description instanceof AxisOperation) {
                    policyPath = engagementPath.substring(0, engagementPath.indexOf("/operation"));
                    policyType = "4";
                }
                this.servicePM.persistServicePolicy(serviceGroupId, policy, policy.getId(), policyType, policyPath, engagementPath);
                description.engageModule(cachingModule);
                if (!transactionStarted) {
                    this.serviceGroupFilePM.commitTransaction(serviceGroupId);
                }
                if (!registryTransactionStarted) {
                    this.configRegistry.commitTransaction();
                }
            }
            catch (Exception e) {
                String msg = "Error persisting caching policy in file system.";
                log.error((Object)msg, (Throwable)e);
                this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                this.configRegistry.rollbackTransaction();
                throw new PersistenceException(msg, (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            try {
                this.configRegistry.rollbackTransaction();
            }
            catch (RegistryException re) {
                log.error((Object)re.getMessage(), (Throwable)re);
            }
            throw new CachingComponentException("errorSavingPolicy", e, log);
        }
    }

    public void globallyEngageCaching(CachingConfigData confData) throws AxisFault, CachingComponentException {
        AxisModule cachingModule = this.axisConfig.getModule("wso2caching");
        String globalPath = PersistenceUtils.getResourcePath((AxisModule)cachingModule);
        try {
            this.ModuleFilePM.beginTransaction(cachingModule.getName());
            if (this.ModuleFilePM.elementExists(cachingModule.getName(), globalPath)) {
                OMElement element = (OMElement)this.ModuleFilePM.get(cachingModule.getName(), globalPath);
                if (!Boolean.parseBoolean(element.getAttributeValue(new QName(GLOBALLY_ENGAGED_CUSTOM)))) {
                    element.addAttribute(GLOBALLY_ENGAGED_CUSTOM, Boolean.TRUE.toString(), null);
                    this.ModuleFilePM.setMetaFileModification(cachingModule.getName());
                }
            } else {
                OMFactory omFactory = OMAbstractFactory.getOMFactory();
                OMElement moduleElement = omFactory.createOMElement("version", null);
                if (cachingModule.getVersion() != null) {
                    moduleElement.addAttribute("id", cachingModule.getVersion().toString(), null);
                } else {
                    moduleElement.addAttribute("id", "undefined", null);
                }
                moduleElement.addAttribute(GLOBALLY_ENGAGED_CUSTOM, Boolean.TRUE.toString(), null);
                this.ModuleFilePM.put(cachingModule.getName(), moduleElement, "/");
            }
            Policy policy = confData.toPolicy();
            this.handleNewPolicyAddition(policy, cachingModule.getPolicySubject(), confData);
            this.persistenceFactory.getModulePM().persistModulePolicy(cachingModule.getName(), cachingModule.getVersion().toString(), policy, policy.getId(), "2", globalPath);
            cachingModule.addParameter(new Parameter(GLOBALLY_ENGAGED_PARAM_NAME, (Object)"true"));
            for (AxisService service : this.axisConfig.getServices().values()) {
                String adminParamValue = (String)service.getParent().getParameterValue(ADMIN_SERVICE_PARAM_NAME);
                String hiddenParamValue = (String)service.getParent().getParameterValue(HIDDEN_SERVICE_PARAM_NAME);
                if (adminParamValue != null && adminParamValue.length() != 0 && Boolean.parseBoolean(adminParamValue.trim()) || hiddenParamValue != null && hiddenParamValue.length() != 0 && Boolean.parseBoolean(hiddenParamValue.trim())) continue;
                this.engageCachingForService(service.getName(), confData);
            }
            this.ModuleFilePM.commitTransaction(cachingModule.getName());
        }
        catch (Exception e) {
            this.ModuleFilePM.rollbackTransaction(cachingModule.getName());
            log.error((Object)"Error occurred in globally engaging caching", (Throwable)e);
            throw new CachingComponentException("errorEngagingModuleAtRegistry", log);
        }
    }

    public void disengageCachingForService(String serviceName) throws CachingComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disabling caching for the service: " + serviceName));
        }
        AxisService axisService = this.retrieveAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        boolean isProxyService = PersistenceUtils.isProxyService((AxisService)axisService);
        String registryCachingPolicyPath = PersistenceUtils.getRegistryResourcePath((AxisService)axisService) + "/policies/" + defaultCachingPolicyId;
        try {
            this.disableCaching(serviceGroupId, (AxisDescription)axisService, serviceXPath, isProxyService, registryCachingPolicyPath);
        }
        catch (AxisFault af) {
            throw new CachingComponentException("errorDisablingCaching", new String[]{serviceName}, af, log);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disengaged caching for the Axis service: " + serviceName));
        }
    }

    public boolean disengageCachingForOperation(String serviceName, String operationName) throws CachingComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disabling caching for the operation: " + operationName + "service: " + serviceName));
        }
        AxisService axisService = this.retrieveAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        boolean isProxyService = PersistenceUtils.isProxyService((AxisService)axisService);
        String registryCachingPolicyPath = PersistenceUtils.getRegistryResourcePath((AxisService)axisService) + "/policies/" + defaultCachingPolicyId;
        AxisModule cachingModule = this.axisConfig.getModule("wso2caching");
        if (axisService.isEngaged(cachingModule)) {
            return true;
        }
        AxisOperation operation = axisService.getOperation(new QName(operationName));
        String operationXPath = PersistenceUtils.getResourcePath((AxisOperation)operation);
        try {
            this.disableCaching(serviceGroupId, (AxisDescription)operation, operationXPath, isProxyService, registryCachingPolicyPath);
        }
        catch (AxisFault af) {
            throw new CachingComponentException("errorDisablingCaching", new String[]{serviceName + "operation : " + operationName}, af, log);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disengaged caching for the Axis operation: " + operationName + "service: " + serviceName));
        }
        return false;
    }

    private void disableCaching(String serviceGroupId, AxisDescription description, String engagementPath, boolean isProxyService, String registryCachingPolicyPath) throws CachingComponentException, AxisFault {
        try {
            AxisModule cachingModule = this.axisConfig.getModule("wso2caching");
            boolean isTransactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
            if (!isTransactionStarted) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            this.serviceGroupFilePM.delete(serviceGroupId, engagementPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)cachingModule.getName()) + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
            if (isProxyService) {
                boolean registryTransactionStarted = Transaction.isStarted();
                if (!registryTransactionStarted) {
                    this.configRegistry.beginTransaction();
                }
                if (this.configRegistry.resourceExists(registryCachingPolicyPath)) {
                    this.configRegistry.delete(registryCachingPolicyPath);
                } else {
                    log.warn((Object)("Could not delete the Caching policy because it does not exist at " + registryCachingPolicyPath));
                }
                if (!registryTransactionStarted) {
                    this.configRegistry.commitTransaction();
                }
            }
            description.disengageModule(cachingModule);
            if (!isTransactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
        }
        catch (Exception e) {
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            log.error((Object)"errorDisablingAtRegistry", (Throwable)e);
            throw new CachingComponentException("errorDisablingAtRegistry", e, log);
        }
    }

    public void disengageGlobalCaching() throws CachingComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Disengaging globally engaged caching");
        }
        AxisModule module = this.axisConfig.getModule("wso2caching");
        try {
            Parameter param;
            OMElement element;
            boolean isTransactionStarted = this.ModuleFilePM.isTransactionStarted(module.getName());
            if (!isTransactionStarted) {
                this.ModuleFilePM.beginTransaction(module.getName());
            }
            String modulePath = PersistenceUtils.getResourcePath((AxisModule)module);
            if (this.ModuleFilePM.elementExists(module.getName(), modulePath) && !Boolean.parseBoolean((element = (OMElement)this.ModuleFilePM.get(module.getName(), modulePath)).getAttributeValue(new QName(GLOBALLY_ENGAGED_CUSTOM)))) {
                element.addAttribute(GLOBALLY_ENGAGED_CUSTOM, Boolean.FALSE.toString(), null);
                this.ModuleFilePM.setMetaFileModification(module.getName());
            }
            if ((param = module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME)) != null) {
                module.removeParameter(module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME));
            }
            for (AxisService service : this.axisConfig.getServices().values()) {
                String adminParamValue = (String)service.getParent().getParameterValue(ADMIN_SERVICE_PARAM_NAME);
                String hiddenParamValue = (String)service.getParent().getParameterValue(HIDDEN_SERVICE_PARAM_NAME);
                if (adminParamValue != null && adminParamValue.length() != 0 && Boolean.parseBoolean(adminParamValue.trim()) || hiddenParamValue != null && hiddenParamValue.length() != 0 && Boolean.parseBoolean(hiddenParamValue.trim())) continue;
                this.disengageCachingForService(service.getName());
            }
            if (!isTransactionStarted) {
                this.ModuleFilePM.commitTransaction(module.getName());
            }
        }
        catch (PersistenceException e) {
            this.ModuleFilePM.rollbackTransaction(module.getName());
            log.error((Object)"Error occured while removing global caching from configRegistry", (Throwable)e);
            throw new CachingComponentException("errorDisablingAtRegistry", log);
        }
        catch (AxisFault e) {
            this.ModuleFilePM.rollbackTransaction(module.getName());
            log.error((Object)"Error occured while disengaging module from AxisService", (Throwable)e);
            throw new CachingComponentException("errorDisablingCaching", log);
        }
    }

    public CachingConfigData getCachingPolicyForService(String serviceName) throws CachingComponentException {
        AxisService service = this.retrieveAxisService(serviceName);
        Collection policyComponents = service.getPolicySubject().getAttachedPolicyComponents();
        return this.getCachingConfig(policyComponents);
    }

    public CachingConfigData getCachingPolicyForOperation(String serviceName, String operationName) throws CachingComponentException {
        AxisService service = this.retrieveAxisService(serviceName);
        AxisOperation operation = service.getOperation(new QName(operationName));
        AxisModule module = this.axisConfig.getModule("wso2caching");
        Policy[] arr = null;
        Collection policyComponents = null;
        if (service.isEngaged(module)) {
            policyComponents = service.getPolicySubject().getAttachedPolicyComponents();
            arr = this.cachingPolicyUtils.retrieveCachingAssertionAndPolicy(policyComponents);
        }
        if (arr == null) {
            policyComponents = operation.getPolicySubject().getAttachedPolicyComponents();
        }
        return this.getCachingConfig(policyComponents);
    }

    public CachingConfigData getGlobalCachingPolicy() throws CachingComponentException {
        AxisModule module = this.axisConfig.getModule("wso2caching");
        Collection policyComponents = module.getPolicySubject().getAttachedPolicyComponents();
        return this.getCachingConfig(policyComponents);
    }

    private void handleNewPolicyAddition(Policy builtPolicy, PolicySubject policySubject, CachingConfigData confData) {
        Collection policyComponents = policySubject.getAttachedPolicyComponents();
        if (policyComponents == null) {
            policySubject.attachPolicy(builtPolicy);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Used the new policy configuration as no existing policy components were found");
            }
        } else {
            Policy[] arr = this.cachingPolicyUtils.retrieveCachingAssertionAndPolicy(policyComponents);
            if (arr == null) {
                policySubject.attachPolicy(builtPolicy);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Used the new policy configuration as no existing caching assertion was found");
                }
            } else {
                this.cachingPolicyUtils.updateCachingAssertion(arr[0], confData);
                policySubject.updatePolicy(arr[1]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The existing caching policy is updated with the new configuration data");
                }
            }
        }
    }

    private CachingConfigData getCachingConfig(Collection policyComponents) {
        Policy[] arr;
        if (policyComponents != null && (arr = this.cachingPolicyUtils.retrieveCachingAssertionAndPolicy(policyComponents)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Returns the configuration data generated from the exisiting caching policy");
            }
            return this.cachingPolicyUtils.generateConfigurationFromPolicy(arr[0]);
        }
        return null;
    }

    public boolean isCachingEnabledForService(String serviceName) throws CachingComponentException {
        AxisService service = this.retrieveAxisService(serviceName);
        AxisModule module = this.axisConfig.getModule("wso2caching");
        return service.isEngaged(module);
    }

    public boolean isCachingEnabledForOperation(String serviceName, String operationName) throws CachingComponentException {
        AxisModule module;
        AxisService service = this.retrieveAxisService(serviceName);
        AxisOperation operation = service.getOperation(new QName(operationName));
        return operation.isEngaged(module = this.axisConfig.getModule("wso2caching")) || service.isEngaged(module);
    }

    public boolean isCachingGloballyEnabled() throws CachingComponentException {
        String globallyEngaged;
        AxisModule module = this.axisConfig.getModule("wso2caching");
        Parameter param = module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME);
        if (param != null && (globallyEngaged = (String)param.getValue()) != null && globallyEngaged.length() != 0) {
            return Boolean.parseBoolean(globallyEngaged.trim());
        }
        return false;
    }

    private AxisService retrieveAxisService(String serviceName) throws CachingComponentException {
        AxisService axisService;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Axis service: " + serviceName));
        }
        if ((axisService = this.axisConfig.getServiceForActivation(serviceName)) == null) {
            throw new CachingComponentException("noSuchService", new String[]{serviceName}, log);
        }
        return axisService;
    }

    private String getModuleResourcePath(AxisModule axisModule) {
        String moduleName = axisModule.getName();
        String moduleVersion = axisModule.getVersion().toString();
        if (moduleVersion == null || moduleVersion.length() == 0) {
            moduleVersion = "SNAPSHOT";
        }
        return "/repository/axis2/modules/" + moduleName + "/" + moduleVersion;
    }
}

