/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.All;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.wso2.carbon.caching.CachingComponentConstants;
import org.wso2.carbon.caching.CachingConfigData;

public class CachingPolicyUtils {
    public static final Log log = LogFactory.getLog(CachingComponentConstants.class);

    public CachingConfigData generateConfigurationFromPolicy(Policy cachingPolicyComponent) {
        CachingConfigData confData = new CachingConfigData();
        XmlPrimtiveAssertion[] assertionArr = this.retrieveConfigPrimitiveAssertions(cachingPolicyComponent);
        confData.setXmlIdentifier(assertionArr[0].getValue().getText());
        confData.setExpTime(Long.parseLong(assertionArr[1].getValue().getText()));
        confData.setMaxCacheSize(Integer.parseInt(assertionArr[2].getValue().getText()));
        confData.setMaxMsgSize(Integer.parseInt(assertionArr[3].getValue().getText()));
        return confData;
    }

    public XmlPrimtiveAssertion[] retrieveConfigPrimitiveAssertions(Policy cachingPolicyComponent) {
        XmlPrimtiveAssertion[] assertionArr = new XmlPrimtiveAssertion[4];
        for (Object policyObject : cachingPolicyComponent.getPolicyComponents()) {
            if (!(policyObject instanceof Policy)) continue;
            for (Object allObject : ((Policy)policyObject).getPolicyComponents()) {
                if (!(allObject instanceof All)) continue;
                for (Object assertionObject : ((All)allObject).getPolicyComponents()) {
                    if (!(assertionObject instanceof XmlPrimtiveAssertion)) continue;
                    XmlPrimtiveAssertion primitiveAssertion = (XmlPrimtiveAssertion)assertionObject;
                    QName assertionName = primitiveAssertion.getName();
                    if (assertionName.equals(CachingComponentConstants.XML_IDENTIFIER_QNAME)) {
                        assertionArr[0] = primitiveAssertion;
                        continue;
                    }
                    if (assertionName.equals(CachingComponentConstants.CACHE_EXPIRATION_TIME_QNAME)) {
                        assertionArr[1] = primitiveAssertion;
                        continue;
                    }
                    if (assertionName.equals(CachingComponentConstants.MAX_CACHE_SIZE_QNAME)) {
                        assertionArr[2] = primitiveAssertion;
                        continue;
                    }
                    if (!assertionName.equals(CachingComponentConstants.MAX_MESSAGE_SIZE_QNAME)) continue;
                    assertionArr[3] = primitiveAssertion;
                }
            }
        }
        return assertionArr;
    }

    public void updateCachingAssertion(Policy cachingPolicyComponent, CachingConfigData confData) {
        XmlPrimtiveAssertion[] assertionArr = this.retrieveConfigPrimitiveAssertions(cachingPolicyComponent);
        assertionArr[0].getValue().setText(confData.getXmlIdentifier());
        assertionArr[1].getValue().setText(String.valueOf(confData.getExpTime()));
        assertionArr[2].getValue().setText(String.valueOf(confData.getMaxCacheSize()));
        assertionArr[3].getValue().setText(String.valueOf(confData.getMaxMsgSize()));
    }

    public Policy[] retrieveCachingAssertionAndPolicy(Collection policyComponents) {
        for (Object policyComponent : policyComponents) {
            if (!(policyComponent instanceof Policy)) continue;
            Policy parentPolicy = (Policy)policyComponent;
            Iterator iterator = parentPolicy.getAlternatives();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof List)) continue;
                List list = (List)object;
                for (Object assertObj : list) {
                    XmlPrimtiveAssertion primitiveAssertion;
                    if (!(assertObj instanceof XmlPrimtiveAssertion) || !(primitiveAssertion = (XmlPrimtiveAssertion)assertObj).getName().equals(CachingComponentConstants.CACHING_ASSERTION_QNAME)) continue;
                    return new Policy[]{PolicyEngine.getPolicy((OMElement)primitiveAssertion.getValue()), parentPolicy};
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Returns null as no caching assertion was found");
        }
        return null;
    }
}

