/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.handlers;

import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.wso2.caching.CachableResponse;
import org.wso2.caching.CacheConfiguration;
import org.wso2.caching.CacheManager;
import org.wso2.caching.CacheReplicationCommand;
import org.wso2.caching.CachingConstants;
import org.wso2.caching.CachingException;
import org.wso2.caching.RequestHash;
import org.wso2.caching.ServiceName;
import org.wso2.caching.digest.DigestGenerator;
import org.wso2.caching.handlers.CachingHandler;
import org.wso2.caching.util.FixedByteArrayOutputStream;

public class CachingInHandler
extends CachingHandler {
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        CacheConfiguration cacheCfg;
        ConfigurationContext cfgCtx;
        OperationContext opCtx;
        block24: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting the execution of the CachingInHandler");
            }
            if (!msgContext.isServerSide()) {
                throw new UnsupportedOperationException("Client side caching is not supported");
            }
            opCtx = msgContext.getOperationContext();
            if (opCtx == null) {
                this.handleException("Unable to perform caching : OperationContext not found to store cache details");
            }
            if ((cfgCtx = msgContext.getConfigurationContext()) == null) {
                this.handleException("Unable to perform caching : ConfigurationContext not found to process cache");
            }
            cacheCfg = null;
            Parameter ccfgParam = msgContext.getAxisMessage().getParameter("cacheConfiguration");
            if (ccfgParam != null && ccfgParam.getValue() instanceof CacheConfiguration) {
                cacheCfg = (CacheConfiguration)ccfgParam.getValue();
            } else {
                this.handleException("Unable to perform caching : Could not find the CacheConfiguration");
            }
            if (cacheCfg.getTimeout() <= 0L) {
                return Handler.InvocationResponse.CONTINUE;
            }
            if (cacheCfg.getMaxMessageSize() > 0) {
                FixedByteArrayOutputStream fbaos = new FixedByteArrayOutputStream(cacheCfg.getMaxMessageSize());
                try {
                    msgContext.getEnvelope().serialize((OutputStream)fbaos);
                }
                catch (XMLStreamException e) {
                    this.handleException("Error in checking the message size", e);
                }
                catch (CachingException che) {
                    if (!log.isDebugEnabled()) break block24;
                    log.debug((Object)"Message size exceeds the upper bound for caching, request will not be cached");
                    return Handler.InvocationResponse.CONTINUE;
                }
            }
        }
        String requestHash = this.getRequestHash(msgContext, cacheCfg);
        CacheManager cacheManager = (CacheManager)cfgCtx.getPropertyNonReplicable("cacheManager");
        String serviceName = msgContext.getAxisService().getName();
        opCtx.setNonReplicableProperty("requestHash", (Object)requestHash);
        ServiceName service = new ServiceName(serviceName);
        RequestHash hash = new RequestHash(requestHash);
        CachableResponse cachedResponse = cacheManager.getCachedResponse(service, hash);
        CacheReplicationCommand cacheReplicationCommand = new CacheReplicationCommand();
        if (cachedResponse != null) {
            if (!cachedResponse.isExpired()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache-hit for message-ID : " + msgContext.getMessageID()));
                }
                cachedResponse.setInUse(true);
                opCtx.setNonReplicableProperty("CachableResponse", (Object)cachedResponse);
                AxisService axisService = msgContext.getAxisService();
                if (axisService != null) {
                    AxisOperation cachedOperation = axisService.getOperation(CachingConstants.CACHED_OPERATION_QNAME);
                    if (cachedOperation != null) {
                        cachedOperation.setControlOperation(true);
                        msgContext.setAxisOperation(cachedOperation);
                    } else {
                        this.handleException("Unable to perform caching : Could not find the cached operation");
                    }
                }
                return Handler.InvocationResponse.CONTINUE;
            }
            cachedResponse.reincarnate(cacheCfg.getTimeout());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Existing cached response has expired. Reset cache element");
            }
            cacheManager.cacheResponse(service, hash, cachedResponse, cacheReplicationCommand);
            opCtx.setNonReplicableProperty("CachableResponse", (Object)cachedResponse);
            opCtx.setNonReplicableProperty("StateReplicationObject", (Object)cacheReplicationCommand);
            return Handler.InvocationResponse.CONTINUE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"There is no cached response for the request. Trying to cache...");
        }
        if (cacheManager.getCacheSize(service) >= (long)cacheCfg.getMaxCacheSize()) {
            cacheManager.removeExpiredResponses(service, cacheReplicationCommand);
            if (cacheManager.getCacheSize(service) >= (long)cacheCfg.getMaxCacheSize()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"In-memory cache is full. Unable to cache");
                }
            } else {
                this.cacheNewResponse(msgContext, service, hash, cacheManager, cacheCfg, cacheReplicationCommand);
            }
        } else {
            this.cacheNewResponse(msgContext, service, hash, cacheManager, cacheCfg, cacheReplicationCommand);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private String getRequestHash(MessageContext msgContext, CacheConfiguration cacheCfg) throws AxisFault {
        String requestHash = null;
        try {
            DigestGenerator digestGenerator = cacheCfg.getDigestGenerator();
            if (digestGenerator != null) {
                requestHash = digestGenerator.getDigest(msgContext);
            } else {
                this.handleException("Unable to retrieve the DigestGenerator from the CacheManager");
            }
        }
        catch (CachingException ce) {
            this.handleException("Unable to perform caching : Error in generating the request hash");
        }
        return requestHash;
    }

    private void cacheNewResponse(MessageContext msgContext, ServiceName serviceName, RequestHash requestHash, CacheManager cacheManager, CacheConfiguration chCfg, CacheReplicationCommand cacheReplicationCommand) {
        CachableResponse response = new CachableResponse();
        response.setRequestHash(requestHash.getRequestHash());
        response.setTimeout(chCfg.getTimeout());
        cacheManager.cacheResponse(serviceName, requestHash, response, cacheReplicationCommand);
        OperationContext opCtx = msgContext.getOperationContext();
        opCtx.setNonReplicableProperty("CachableResponse", (Object)response);
        opCtx.setNonReplicableProperty("StateReplicationObject", (Object)cacheReplicationCommand);
    }
}

