/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.samples;

import java.io.File;
import java.io.FileInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;

public class SoapSender {
    public void send(String host, int port, String proxy) throws AxisFault {
        ServiceClient serviceClient;
        System.out.println("[ Executing SOAPSender : HOST:" + host + "  ;port :" + port + " ;proxy :" + proxy + " ]");
        String repo = SoapSender.getProperty("repoitory", "null");
        String metaDataFile = SoapSender.getProperty("metaFile", "meta/sample_req.xml");
        String addUrl = SoapSender.getProperty("addurl", "null");
        String trpUrl = SoapSender.getProperty("trpurl", "http://" + host + ":" + port + "/services/" + proxy);
        ConfigurationContext configCtx = null;
        Options option = new Options();
        OMElement payLoad = null;
        if (repo != null && !"null".equals(repo)) {
            configCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
            serviceClient = new ServiceClient(configCtx, null);
        } else {
            serviceClient = new ServiceClient();
        }
        if (metaDataFile != null) {
            payLoad = SoapSender.loadXMLAsElement(metaDataFile);
            if (addUrl != null && !"null".equals(addUrl)) {
                serviceClient.engageModule("addressing");
                option.setTo(new EndpointReference(addUrl));
            }
            if (trpUrl != null && !"null".equals(trpUrl)) {
                option.setProperty("TransportURL", (Object)trpUrl);
            }
            serviceClient.setOptions(option);
            OMElement result = serviceClient.sendReceive(payLoad);
            System.out.println("Received reponse from the server:\n" + result);
        } else {
            System.out.println("The meata data descriptor file is required");
        }
    }

    private static String getProperty(String name, String defaultVal) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = defaultVal;
        }
        return result;
    }

    private static OMElement loadXMLAsElement(String file) {
        OMElement rootElement = null;
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(file));
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            rootElement = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootElement;
    }

    public static void main(String[] args) throws AxisFault {
        String host = System.getProperty("hl7-host");
        String port = System.getProperty("hl7-port");
        String proxy = System.getProperty("hl7-proxy");
        if (!(host == null || port == null || proxy == null || "".equals(host) || "".equals(port) || "".equals(proxy))) {
            new SoapSender().send(host, Integer.parseInt(port), proxy);
        } else {
            new SoapSender().send("localhost", 8280, "HL7SoapProxy");
        }
    }
}

