/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.samples;

import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.SimpleServer;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import java.lang.management.ManagementFactory;
import org.wso2.carbon.business.messaging.hl7.samples.SampleApp;

public class HL7Server {
    private SimpleServer server;

    public HL7Server(int port) {
        LowerLayerProtocol llp = LowerLayerProtocol.makeLLP();
        PipeParser parser = new PipeParser();
        this.server = new SimpleServer(port, llp, (Parser)parser);
    }

    public void start() {
        SampleApp handler = new SampleApp();
        this.server.registerApplication("*", "*", (Application)handler);
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }

    public static void main(String[] args) {
        String port = System.getProperty("hl7-port");
        if (port != null && !"".equals(port)) {
            System.out.println("Server started on Port : " + port + "  Process details : " + ManagementFactory.getRuntimeMXBean().getName());
            new HL7Server(Integer.parseInt(port)).start();
        } else {
            System.out.println("Server started on Port : 9988  Process details : " + ManagementFactory.getRuntimeMXBean().getName());
            new HL7Server(9988).start();
        }
    }
}

