/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.samples;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionHub;
import ca.uhn.hl7v2.app.Initiator;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import java.io.IOException;
import org.wso2.carbon.business.messaging.hl7.samples.HL7Message;

public class HL7Sender {
    public void send(String host, int port) throws HL7Exception {
        System.out.println("[ Executing HL7Sender : HOST:" + host + "  ;port :" + port + " ]");
        ConnectionHub connectionHub = ConnectionHub.getInstance();
        Connection connection = connectionHub.attach(host, port, (Parser)new PipeParser(), MinLowerLayerProtocol.class);
        Initiator initiator = connection.getInitiator();
        HL7Message sampleMessage = new HL7Message();
        Message response = null;
        try {
            response = initiator.sendAndReceive(sampleMessage.getHL7Message());
            PipeParser parser = new PipeParser();
            String responseString = parser.encode(response);
            System.out.println("Received response:\n" + responseString);
        }
        catch (LLPException e) {
            System.out.println("Error : " + (Object)((Object)e));
        }
        catch (IOException e) {
            System.out.println("Error : " + e);
        }
        connectionHub.discard(connection);
    }

    public static void main(String[] args) throws HL7Exception {
        String host = System.getProperty("hl7-host");
        String port = System.getProperty("hl7-port");
        if (host != null && port != null && !"".equals(host) && !"".equals(port)) {
            new HL7Sender().send(host, Integer.parseInt(port));
        } else {
            new HL7Sender().send("localhost", 9293);
        }
    }
}

