/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.message.internal;

import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.business.messaging.hl7.message.HL7MessageBuilder;
import org.wso2.carbon.business.messaging.hl7.message.HL7MessageFormatter;
import org.wso2.carbon.utils.ConfigurationContextService;

public class HL7MessageServiceComponent {
    private static Log log = LogFactory.getLog(HL7MessageServiceComponent.class);
    private ConfigurationContextService contextService;

    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"HL7 Message Service activated");
        }
        try {
            if (this.contextService == null) {
                throw new Exception("ConfigurationContext is not found while loading org.wso2.carbon.transport.fix bundle");
            }
            ConfigurationContext configContext = this.contextService.getServerConfigContext();
            configContext.getAxisConfiguration().addMessageBuilder("application/edi-hl7", (Builder)new HL7MessageBuilder());
            configContext.getAxisConfiguration().addMessageFormatter("application/edi-hl7", (MessageFormatter)new HL7MessageFormatter());
            if (log.isDebugEnabled()) {
                log.info((Object)"Set the HL7 message builder and formatter in the Axis2 context");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully registered the HL7 Message Service");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating HL7 Message Bundle", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"HL7 Message Service deactivated");
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = null;
    }
}

