/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.business.messaging.hl7.common.HL7ProcessingContext;

public class HL7MessageFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(HL7MessageFormatter.class);
    private DefaultXMLParser xmlParser = new DefaultXMLParser();
    private PipeParser pipeParser = new PipeParser();

    public HL7MessageFormatter() {
        this.xmlParser.setValidationContext((ValidationContext)new NoValidation());
        this.pipeParser.setValidationContext((ValidationContext)new NoValidation());
    }

    public byte[] getBytes(MessageContext messageContext, OMOutputFormat omOutputFormat) throws AxisFault {
        return new byte[0];
    }

    public void writeTo(MessageContext msgCtx, OMOutputFormat omOutputFormat, OutputStream outputStream, boolean b) throws AxisFault {
        HL7ProcessingContext processingCtx;
        OMElement omElement = msgCtx.getEnvelope().getBody().getFirstElement().getFirstElement();
        try {
            processingCtx = new HL7ProcessingContext(true, false, null, null);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Inside the HL7 formatter: " + omElement.toString()));
        }
        if (msgCtx.getFLOW() == 4 || msgCtx.getEnvelope().hasFault()) {
            SOAPFault soapFault = msgCtx.getEnvelope().getBody().getFault();
            try {
                Message message = processingCtx.createNack((Message)msgCtx.getProperty("HL7_MESSAGE_OBJECT"), soapFault.getReason().getText());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Generate HL7 error: " + message));
                }
                this.writeMessageOut(message, outputStream, msgCtx);
            }
            catch (HL7Exception e) {
                throw new AxisFault("Error on creating HL7 Error segment: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new AxisFault("Error on writing HL7 Error to output stream: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            String xmlFormat = omElement.toString();
            Message message = this.xmlParser.parse(xmlFormat);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Message inside the formatter: " + message));
            }
            if (this.isGenerateMessageAck(msgCtx)) {
                message = this.createGeneratedMessageAck(processingCtx, message, msgCtx);
            }
            this.writeMessageOut(message, outputStream, msgCtx);
        }
        catch (Exception e) {
            throw new AxisFault("Error occured during HL7 message creation: " + e.getMessage(), (Throwable)e);
        }
    }

    private Message createGeneratedMessageAck(HL7ProcessingContext processingCtx, Message message, MessageContext msgCtx) throws HL7Exception {
        try {
            return processingCtx.handleHL7Result(msgCtx, message);
        }
        catch (HL7Exception e) {
            return processingCtx.createNack(null, e.getMessage());
        }
    }

    private boolean isGenerateMessageAck(MessageContext msgCtx) {
        Object param = msgCtx.getProperty("HL7_GENERATE_ACK");
        if (param != null) {
            return Boolean.parseBoolean(param.toString());
        }
        return false;
    }

    private void writeMessageOut(Message message, OutputStream out, MessageContext msgCtx) throws IOException, HL7Exception {
        msgCtx.setProperty("ContentType", (Object)"application/edi-hl7");
        String txtMsg = this.pipeParser.encode(message);
        out.write(txtMsg.getBytes());
        out.flush();
    }

    public String getContentType(MessageContext msgCtx, OMOutputFormat omOutputFormat, String s) {
        String encoding;
        String contentType = (String)msgCtx.getProperty("ContentType");
        if (contentType == null) {
            contentType = "application/edi-hl7";
        }
        if ((encoding = omOutputFormat.getCharSetEncoding()) != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat omOutputFormat, URL targetURL) throws AxisFault {
        return URLTemplatingUtil.getTemplatedURL((URL)targetURL, (MessageContext)messageContext, (boolean)false);
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat omOutputFormat, String soapAction) {
        return soapAction;
    }
}

