/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.io.InputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.business.messaging.hl7.common.HL7ProcessingContext;
import org.wso2.carbon.business.messaging.hl7.common.HL7Utils;

public class HL7MessageBuilder
implements Builder {
    private static final Log log = LogFactory.getLog(HL7MessageBuilder.class);

    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext msgCtx) throws AxisFault {
        try {
            HL7ProcessingContext processingCtx = new HL7ProcessingContext(msgCtx.getAxisService());
            String hl7String = HL7Utils.streamToString((InputStream)inputStream);
            if (log.isDebugEnabled()) {
                log.debug((Object)("HL7 String: " + hl7String));
            }
            Message message = processingCtx.parseMessage(hl7String);
            processingCtx.initMessageContext(message, msgCtx);
            processingCtx.checkConformanceProfile(message);
            String hl7Xml = this.serializeHL7toXML(message);
            return HL7Utils.generateHL7MessageElement((String)hl7Xml);
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    private String serializeHL7toXML(Message message) throws AxisFault {
        DefaultXMLParser xmlParser = new DefaultXMLParser();
        xmlParser.setValidationContext((ValidationContext)new NoValidation());
        try {
            return xmlParser.encode(message);
        }
        catch (HL7Exception e) {
            throw new AxisFault("Error on converting to HL7 XML: " + e.getMessage(), (Throwable)e);
        }
    }
}

